/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestOrderBefore
extends OrderPatchTest {
    protected Node orderBeforeNode;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.refresh(false);
        if (this.orderBeforeNode == null) {
            this.orderBeforeNode = this.orderPatchNode.addNode("orderBeforeNode", "nt:unstructured");
            this.session.save();
            for (int i = 1; i <= 5; ++i) {
                this.orderBeforeNode.addNode("n" + i, "nt:unstructured");
            }
            this.session.save();
        }
    }

    public void testOrderBefore1() throws Exception {
        this.assertOrder(this.orderBeforeNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderBeforeNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n3</D:segment><D:position><D:before><D:segment>n2</D:segment></D:before></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderBefore.assertEquals((int)200, (int)response.getStatus());
        this.assertOrder(this.orderBeforeNode, new String[]{"n1", "n3", "n2", "n4", "n5"});
    }

    public void testOrderBefore2() throws Exception {
        this.assertOrder(this.orderBeforeNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderBeforeNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n4</D:segment><D:position><D:before><D:segment>n2</D:segment></D:before></D:position></D:order-member><D:order-member><D:segment>n1</D:segment><D:position><D:before><D:segment>n0</D:segment></D:before></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderBefore.assertEquals((int)207, (int)response.getStatus());
        OrderPatchResponseEntity entity = (OrderPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        HierarchicalPropertyEntityProvider entityProvider = new HierarchicalPropertyEntityProvider();
        HierarchicalProperty multistatus = entityProvider.readFrom(null, null, null, null, null, (InputStream)new ByteArrayInputStream(resp.getBytes()));
        TestOrderBefore.assertEquals((Object)new QName("DAV:", "multistatus"), (Object)multistatus.getName());
        TestOrderBefore.assertEquals((int)2, (int)multistatus.getChildren().size());
        HierarchicalProperty response1 = multistatus.getChild(0);
        String href1MustBe = TextUtil.escape((String)(this.getPathWS() + this.orderBeforeNode.getPath() + "/n4"), (char)'%', (boolean)true);
        String href1 = response1.getChild(new QName("DAV:", "href")).getValue();
        TestOrderBefore.assertEquals((String)href1MustBe, (String)href1);
        String status1 = WebDavConst.getStatusDescription((int)200);
        TestOrderBefore.assertEquals((String)status1, (String)response1.getChild(new QName("DAV:", "status")).getValue());
        HierarchicalProperty response2 = multistatus.getChild(1);
        String href2MustBe = TextUtil.escape((String)(this.getPathWS() + this.orderBeforeNode.getPath() + "/n1"), (char)'%', (boolean)true);
        String href2 = response2.getChild(new QName("DAV:", "href")).getValue();
        TestOrderBefore.assertEquals((String)href2MustBe, (String)href2);
        String status2 = WebDavConst.getStatusDescription((int)403);
        TestOrderBefore.assertEquals((String)status2, (String)response2.getChild(new QName("DAV:", "status")).getValue());
        this.assertOrder(this.orderBeforeNode, new String[]{"n1", "n4", "n2", "n3", "n5"});
    }
}

