/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import javax.ws.rs.ext.RuntimeDelegate;
import junit.framework.TestCase;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.webdav.WebDavServiceInitParams;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;

public class TestWebDavServiceInitParams
extends TestCase {
    public void testInitParams() {
        WebDavServiceInitParams params = new WebDavServiceInitParams();
        TestWebDavServiceInitParams.assertEquals((String)"nt:folder", (String)params.getDefaultFolderNodeType());
        TestWebDavServiceInitParams.assertEquals((String)"nt:file", (String)params.getDefaultFileNodeType());
        TestWebDavServiceInitParams.assertEquals((String)"application/octet-stream", (String)params.getDefaultFileMimeType());
        TestWebDavServiceInitParams.assertEquals((String)"create-version", (String)params.getDefaultUpdatePolicyType());
        TestWebDavServiceInitParams.assertEquals((String)"checkout-checkin", (String)params.getDefaultAutoVersionType());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getXsltParams().isEmpty());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getUntrustedUserAgents().isEmpty());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getUntrustedUserAgentsPattern().isEmpty());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getCacheControlMap().isEmpty());
        TestWebDavServiceInitParams.assertEquals((int)1, (int)params.getAllowedFolderNodeTypes().size());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getAllowedFolderNodeTypes().contains("nt:folder"));
        TestWebDavServiceInitParams.assertEquals((int)1, (int)params.getAllowedFileNodeTypes().size());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getAllowedFileNodeTypes().contains("nt:file"));
        InitParams ip = new InitParams();
        ValueParam vp = new ValueParam();
        vp.setName("def-folder-node-type");
        vp.setValue("def-folder-node-type");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("def-file-node-type");
        vp.setValue("def-file-node-type");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("def-file-mimetype");
        vp.setValue("def-file-mimetype");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("update-policy");
        vp.setValue("update-policy");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("auto-version");
        vp.setValue("auto-version");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("file-icon-path");
        vp.setValue("file-icon-path");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("folder-icon-path");
        vp.setValue("folder-icon-path");
        ip.addParameter((Parameter)vp);
        vp = new ValueParam();
        vp.setName("cache-control");
        vp.setValue("text/xml,text/html:max-age=1800;text/*:max-age=777;image/png,image/jpg:max-age=3600;*/*:no-cache;image/*:max-age=555");
        ip.addParameter((Parameter)vp);
        ValuesParam vsp = new ValuesParam();
        vsp.setName("untrusted-user-agents");
        vsp.getValues().add("untrusted-user-agents");
        vsp.getValues().add("untrusted-user-agents2");
        vsp.getValues().add("^(Microsoft Office Excel 2013).*(Windows NT 6.1)$");
        ip.addParameter((Parameter)vsp);
        vsp = new ValuesParam();
        vsp.setName("allowed-folder-node-types");
        vsp.getValues().add("allowed-folder-node-types");
        ip.addParameter((Parameter)vsp);
        vsp = new ValuesParam();
        vsp.setName("allowed-file-node-types");
        vsp.getValues().add("allowed-file-node-types");
        ip.addParameter((Parameter)vsp);
        TestWebDavServiceInitParams.assertEquals((int)11, (int)ip.size());
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        params = new WebDavServiceInitParams(ip);
        TestWebDavServiceInitParams.assertEquals((String)"def-folder-node-type", (String)params.getDefaultFolderNodeType());
        TestWebDavServiceInitParams.assertEquals((String)"def-file-node-type", (String)params.getDefaultFileNodeType());
        TestWebDavServiceInitParams.assertEquals((String)"def-file-mimetype", (String)params.getDefaultFileMimeType());
        TestWebDavServiceInitParams.assertEquals((String)"update-policy", (String)params.getDefaultUpdatePolicyType());
        TestWebDavServiceInitParams.assertEquals((String)"auto-version", (String)params.getDefaultAutoVersionType());
        TestWebDavServiceInitParams.assertEquals((int)2, (int)params.getXsltParams().size());
        TestWebDavServiceInitParams.assertEquals((String)"file-icon-path", (String)((String)params.getXsltParams().get("file-icon-path")));
        TestWebDavServiceInitParams.assertEquals((String)"folder-icon-path", (String)((String)params.getXsltParams().get("folder-icon-path")));
        TestWebDavServiceInitParams.assertEquals((int)3, (int)params.getUntrustedUserAgents().size());
        TestWebDavServiceInitParams.assertEquals((int)3, (int)params.getUntrustedUserAgentsPattern().size());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getUntrustedUserAgents().contains("untrusted-user-agents"));
        TestWebDavServiceInitParams.assertTrue((boolean)params.isUntrustedUserAgent("untrusted-user-agents"));
        TestWebDavServiceInitParams.assertTrue((boolean)params.getUntrustedUserAgents().contains("untrusted-user-agents2"));
        TestWebDavServiceInitParams.assertTrue((boolean)params.isUntrustedUserAgent("untrusted-user-agents2"));
        TestWebDavServiceInitParams.assertTrue((boolean)params.isUntrustedUserAgent("Microsoft Office Excel 2013 (15.0.4701) Windows NT 6.1"));
        TestWebDavServiceInitParams.assertTrue((boolean)params.isUntrustedUserAgent("Microsoft Office Excel 2013 (15.0.4631) Windows NT 6.1"));
        TestWebDavServiceInitParams.assertFalse((boolean)params.isUntrustedUserAgent("Microsoft Office Excel 2013"));
        TestWebDavServiceInitParams.assertFalse((boolean)params.isUntrustedUserAgent("Microsoft Office PowerPoint 2013"));
        TestWebDavServiceInitParams.assertEquals((int)7, (int)params.getCacheControlMap().size());
        TestWebDavServiceInitParams.assertEquals((int)1, (int)params.getAllowedFolderNodeTypes().size());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getAllowedFolderNodeTypes().contains("allowed-folder-node-types"));
        TestWebDavServiceInitParams.assertEquals((int)1, (int)params.getAllowedFileNodeTypes().size());
        TestWebDavServiceInitParams.assertTrue((boolean)params.getAllowedFileNodeTypes().contains("allowed-file-node-types"));
    }
}

