/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindResponseEntity;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.w3c.dom.Document;

public class TestUtils {
    public static final String HOST = "localhost";
    public static final String SERVLET_PATH = "/rest/jcr/repository";
    public static final String WORKSPACE = "/ws";
    public static final String INAVLID_WORKSPACE = "/invalid";
    public static final String REALM = "eXo REST services";
    public static final String ROOTID = "root";
    public static final String ROOTPASS = "exo";

    public static HTTPConnection GetAuthConnection() {
        HTTPConnection connection = new HTTPConnection(HOST, 8080);
        connection.addBasicAuthorization(REALM, ROOTID, ROOTPASS);
        return connection;
    }

    public static String getFullPath() {
        return "http://localhost:8080/rest/jcr/repository/ws";
    }

    public static String getFullWorkSpacePath() {
        return "/rest/jcr/repository/ws";
    }

    public static String getFullUri() {
        return "http://localhost:8080" + TestUtils.getFullWorkSpacePath();
    }

    public static String getFolderName() {
        return "/test-folder-" + System.nanoTime();
    }

    public static String getFileName() {
        return "/test-file-" + System.nanoTime() + ".txt";
    }

    public static Document getXmlFromString(String string) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(string.getBytes());
        return builderFactory.newDocumentBuilder().parse(inputStream);
    }

    public static String getFileContent() {
        Object content = new String();
        for (int i = 0; i < 10; ++i) {
            content = (String)content + UUID.randomUUID().toString();
        }
        return content;
    }

    public static Node addContent(Session session, String path, InputStream inputStream, String nodeType, String mimeType) throws RepositoryException {
        return TestUtils.addContent(session, path, inputStream, nodeType, "nt:resource", mimeType);
    }

    public static Node addContent(Session session, String path, InputStream inputStream, String nodeType, String contentType, String mimeType) throws RepositoryException {
        Node node = session.getRootNode().addNode(TextUtil.relativizePath((String)path), nodeType);
        node.addNode("jcr:content", contentType);
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", inputStream);
        session.save();
        return node;
    }

    public static void addFolder(Session session, String path, String nodeType, String mimeType) throws RepositoryException {
        session.getRootNode().addNode(TextUtil.relativizePath((String)path), nodeType);
        session.save();
    }

    public static String stream2string(InputStream stream, String charset) throws IOException {
        int n;
        InputStreamReader r = charset != null ? new InputStreamReader(stream, charset) : new InputStreamReader(stream);
        StringWriter sw = new StringWriter();
        char[] buffer = new char[1024];
        while ((n = r.read(buffer)) != -1) {
            sw.write(buffer, 0, n);
        }
        String str = sw.toString();
        return str;
    }

    public static Property getNodeProperty(Session session, String path, String property) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        if (node.hasProperty(property)) {
            return node.getProperty(property);
        }
        return null;
    }

    public static void addNodeProperty(Session session, String path, String propName, String propValue) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        node.setProperty(propName, propValue);
        session.save();
    }

    public static String lockNode(Session session, String path, Boolean depth) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        if (!node.isNodeType("mix:lockable") && node.canAddMixin("mix:lockable")) {
            node.addMixin("mix:lockable");
            session.save();
        }
        Lock lock = node.lock(depth.booleanValue(), true);
        session.save();
        String tok = lock.getLockToken();
        return "<opaquelocktoken:" + tok + ">";
    }

    public static void find(Session session, String queryString) throws InvalidQueryException, RepositoryException {
        Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "sql");
        QueryResult queryResult = query.execute();
    }

    public static String getFileNodeType(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        return node.getPrimaryNodeType().getName();
    }

    public static String getContentNodeType(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        Node content = node.getNode("jcr:content");
        return content.getPrimaryNodeType().getName();
    }

    public static Node getContentNode(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        return node.getNode("jcr:content");
    }

    public static NodeType[] getContentMixins(Session session, String path) throws PathNotFoundException, RepositoryException {
        Node node = session.getRootNode().getNode(TextUtil.relativizePath((String)path));
        Node content = node.getNode("jcr:content");
        return content.getMixinNodeTypes();
    }

    public static InputStream getResponseAsStream(ContainerResponse response) throws IOException {
        if (response.getEntity() instanceof PropFindResponseEntity) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ((PropFindResponseEntity)response.getEntity()).write((OutputStream)outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        return null;
    }
}

