/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.LockCommand;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestLock
extends BaseStandaloneTest {
    private String path = TestUtils.getFileName();
    private String fileContent = TestUtils.getFileContent();
    private String lockRequestBody = "<D:lockinfo xmlns:D='DAV:'><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype><D:owner><D:href>testOwner</D:href></D:owner></D:lockinfo>";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)this.path));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileContent.getBytes());
        TestUtils.addContent((Session)this.session, this.path, inputStream, this.defaultFileNodeType, "");
        this.path = this.path + "[2]";
    }

    public void testLock() throws Exception {
        this.testLock(this.getPathWS());
    }

    public void testLockWithFakePathWS() throws Exception {
        this.testLock(this.getFakePathWS());
    }

    private void testLock(String pathWs) throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-type", (Object)"text/plain");
        ContainerResponse containerResponse = this.serviceWithEscape("LOCK", pathWs + this.path, "", (MultivaluedMap<String, String>)headers, this.lockRequestBody.getBytes());
        TestLock.assertEquals((int)200, (int)containerResponse.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LockCommand.LockResultResponseEntity entity = (LockCommand.LockResultResponseEntity)containerResponse.getEntity();
        entity.write((OutputStream)outputStream);
        containerResponse = this.serviceWithEscape("DELETE", pathWs + this.path, "", null, null);
        TestLock.assertEquals((int)423, (int)containerResponse.getStatus());
        TestLock.assertTrue((boolean)this.session.getRootNode().getNode(TextUtil.relativizePath((String)this.path)).isLocked());
        String lockToken = outputStream.toString();
        lockToken = lockToken.substring(lockToken.indexOf(">opaquelocktoken:"));
        lockToken = lockToken.substring(lockToken.indexOf(":") + 1, lockToken.indexOf("<"));
        this.session.addLockToken(lockToken);
        ((Node)this.session.getItem(this.path)).unlock();
    }

    public void testLockRefresh() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)"text/plain");
        ContainerResponse containerResponse = this.serviceWithEscape("LOCK", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, this.lockRequestBody.getBytes());
        TestLock.assertEquals((int)200, (int)containerResponse.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LockCommand.LockResultResponseEntity entity = (LockCommand.LockResultResponseEntity)containerResponse.getEntity();
        entity.write((OutputStream)outputStream);
        String lockToken = outputStream.toString();
        lockToken = lockToken.substring(lockToken.indexOf(">opaquelocktoken:"));
        lockToken = lockToken.substring(lockToken.indexOf(":") + 1, lockToken.indexOf("<"));
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-type", (Object)"text/plain");
        headers.add((Object)"lock-token", (Object)lockToken);
        containerResponse = this.serviceWithEscape("LOCK", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, null);
        TestLock.assertEquals((int)200, (int)containerResponse.getStatus());
        outputStream = new ByteArrayOutputStream();
        entity = (LockCommand.LockResultResponseEntity)containerResponse.getEntity();
        entity.write((OutputStream)outputStream);
        this.session.addLockToken(lockToken);
        ((Node)this.session.getItem(this.path)).unlock();
    }

    public void testAlreadyLocked() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-type", (Object)"text/plain");
        ContainerResponse containerResponse = this.serviceWithEscape("LOCK", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, this.lockRequestBody.getBytes());
        TestLock.assertEquals((int)200, (int)containerResponse.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LockCommand.LockResultResponseEntity entity = (LockCommand.LockResultResponseEntity)containerResponse.getEntity();
        entity.write((OutputStream)outputStream);
        String lockToken = outputStream.toString();
        lockToken = lockToken.substring(lockToken.indexOf(">opaquelocktoken:"));
        lockToken = lockToken.substring(lockToken.indexOf(":") + 1, lockToken.indexOf("<"));
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-type", (Object)"text/plain");
        containerResponse = this.serviceWithEscape("LOCK", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, this.lockRequestBody.getBytes());
        TestLock.assertEquals((int)423, (int)containerResponse.getStatus());
        this.session.addLockToken(lockToken);
        ((Node)this.session.getItem(this.path)).unlock();
    }

    public void testLockForNonExistingWorkspace() throws Exception {
        ContainerResponse response = this.serviceWithEscape("LOCK", this.getPathWS() + "_" + this.path, "", null, this.lockRequestBody.getBytes());
        TestLock.assertEquals((int)409, (int)response.getStatus());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

