/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchTest;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestMultipleOrder
extends OrderPatchTest {
    protected Node multipleOrderNode;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.refresh(false);
        if (this.multipleOrderNode == null) {
            this.multipleOrderNode = this.orderPatchNode.addNode("multipleOrderNode", "nt:unstructured");
            this.session.save();
            for (int i = 1; i <= 5; ++i) {
                this.multipleOrderNode.addNode("n" + i, "nt:unstructured");
            }
            this.session.save();
        }
    }

    public void testMultipleOrder() throws Exception {
        this.assertOrder(this.multipleOrderNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.multipleOrderNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n1</D:segment><D:position><D:before><D:segment>n4</D:segment></D:before></D:position></D:order-member><D:order-member><D:segment>n4</D:segment><D:position><D:before><D:segment>n3</D:segment></D:before></D:position></D:order-member><D:order-member><D:segment>n2</D:segment><D:position><D:last/></D:position></D:order-member><D:order-member><D:segment>n5</D:segment><D:position><D:first/></D:position></D:order-member><D:order-member><D:segment>n3</D:segment><D:position><D:after><D:segment>n2</D:segment></D:after></D:position></D:order-member><D:order-member><D:segment>n5</D:segment><D:position><D:after><D:segment>n1</D:segment></D:after></D:position></D:order-member><D:order-member><D:segment>n0</D:segment><D:position><D:first/></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestMultipleOrder.assertEquals((int)207, (int)response.getStatus());
        OrderPatchResponseEntity entity = (OrderPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        HierarchicalPropertyEntityProvider entityProvider = new HierarchicalPropertyEntityProvider();
        HierarchicalProperty multistatus = entityProvider.readFrom(null, null, null, null, null, (InputStream)new ByteArrayInputStream(resp.getBytes()));
        TestMultipleOrder.assertEquals((Object)new QName("DAV:", "multistatus"), (Object)multistatus.getName());
        for (int i = 0; i < 6; ++i) {
            HierarchicalProperty respProperty = multistatus.getChild(i);
            String okStatus = WebDavConst.getStatusDescription((int)200);
            TestMultipleOrder.assertEquals((String)okStatus, (String)respProperty.getChild(new QName("DAV:", "status")).getValue());
        }
        HierarchicalProperty badResp = multistatus.getChild(6);
        String forbiddenStatus = WebDavConst.getStatusDescription((int)403);
        TestMultipleOrder.assertEquals((String)forbiddenStatus, (String)badResp.getChild(new QName("DAV:", "status")).getValue());
        this.assertOrder(this.multipleOrderNode, new String[]{"n4", "n1", "n5", "n2", "n3"});
    }
}

