/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.ext;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.ext.CacheControlType;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestCaching
extends BaseStandaloneTest {
    private String path = TestUtils.getFileName();
    private String fileContent = TestUtils.getFileContent();
    private Node node;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileContent.getBytes());
        this.node = TestUtils.addContent((Session)this.session, this.path, inputStream, this.defaultFileNodeType, "");
    }

    public void testNotModifiedSince() throws Exception {
        Node contentNode = this.node.getNode("jcr:content");
        Property lastModifiedProperty = contentNode.getProperty("jcr:lastModified");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        Calendar lastModifiedDate = Calendar.getInstance();
        lastModifiedDate.setTimeInMillis(lastModifiedProperty.getDate().getTimeInMillis());
        lastModifiedDate.add(13, -10);
        String ifModifiedDate = dateFormat.format(lastModifiedDate.getTime());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"If-Modified-Since", (Object)ifModifiedDate);
        ContainerResponse response = this.service("GET", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, null);
        TestCaching.assertEquals((int)200, (int)response.getStatus());
    }

    public void testIfModifiedSince() throws Exception {
        Node contentNode = this.node.getNode("jcr:content");
        Property lastModifiedProperty = contentNode.getProperty("jcr:lastModified");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        Calendar lastModifiedDate = lastModifiedProperty.getDate();
        lastModifiedDate.add(4, 1);
        String ifModifiedDate = dateFormat.format(lastModifiedDate.getTime());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"If-Modified-Since", (Object)ifModifiedDate);
        ContainerResponse response = this.service("GET", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, null);
        TestCaching.assertEquals((int)304, (int)response.getStatus());
    }

    public void _testModifiedSinceLocaleFR() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.FRENCH);
        String ifModifiedDate = sdf.format(sdf.getCalendar().getTime());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"If-Modified-Since", (Object)ifModifiedDate);
        ContainerResponse response = this.service("GET", this.getPathWS() + this.path, "", (MultivaluedMap<String, String>)headers, null);
        TestCaching.assertEquals((int)200, (int)response.getStatus());
    }

    public void testCacheConf() throws Exception {
        ArrayList<CacheControlType> testValues = new ArrayList<CacheControlType>();
        testValues.add(new CacheControlType("text/xml", "max-age=1800"));
        testValues.add(new CacheControlType("text/pdf", "max-age=777"));
        testValues.add(new CacheControlType("image/jpg", "max-age=3600"));
        testValues.add(new CacheControlType("image/gif", "max-age=555"));
        testValues.add(new CacheControlType("test/test", "no-cache"));
        testValues.add(new CacheControlType("*/*", "no-cache"));
        Node contentNode = this.node.getNode("jcr:content");
        for (CacheControlType cacheControlType : testValues) {
            contentNode.setProperty("jcr:mimeType", cacheControlType.getContentType());
            contentNode.getSession().save();
            ContainerResponse response = this.service("GET", this.getPathWS() + this.path, "", null, null);
            String cacheControlHeader = ((List)response.getHttpHeaders().get((Object)"Cache-Control")).toString();
            cacheControlHeader = cacheControlHeader.substring(1, cacheControlHeader.length() - 1);
            TestCaching.assertEquals((String)cacheControlHeader, (String)cacheControlType.getCacheValue());
        }
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

