/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.ext;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.proppatch.PropPatchResponseEntity;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestPropPatchContent
extends BaseStandaloneTest {
    @Override
    protected String getRepositoryName() {
        return null;
    }

    public void testProppatchSetContentProp() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String propName1 = "webdav:prop1";
        String propName2 = "webdav:prop2";
        content.setProperty(propName1, "value1");
        content.setProperty(propName2, "value2");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\" xmlns:jcr=\"jcr:\"><D:set><D:prop><webdav:Author>Author</webdav:Author><jcr:content><webdav:prop1>testValue1</webdav:prop1><webdav:prop2>testValue2</webdav:prop2></jcr:content></D:prop></D:set></D:propertyupdate>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropPatchContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropPatchContent.getContentNode(node);
        TestPropPatchContent.assertEquals((String)"testValue1", (String)content.getProperty(propName1).getValue().getString());
        TestPropPatchContent.assertEquals((String)"testValue2", (String)content.getProperty(propName2).getValue().getString());
    }

    public void testProppatchRemoveContentProp() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String propName1 = "webdav:prop1";
        content.setProperty(propName1, "value1");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\" xmlns:jcr=\"jcr:\"><D:remove><D:prop><webdav:Author>Author</webdav:Author><jcr:content><webdav:prop1/></jcr:content></D:prop></D:remove></D:propertyupdate>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropPatchContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropPatchContent.getContentNode(node);
        try {
            content.getProperty(propName1);
            TestPropPatchContent.fail();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testProppatchSetJcrData() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "data");
        String propName1 = "jcr:data";
        content.setProperty(propName1, "data");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\" xmlns:jcr=\"jcr:\"><D:set><D:prop><jcr:content><jcr:data>testData</jcr:data></jcr:content></D:prop></D:set></D:propertyupdate>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropPatchContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropPatchContent.getContentNode(node);
        Property p = content.getProperty(propName1);
        System.out.println(p.getString());
        TestPropPatchContent.assertEquals((String)"data", (String)p.getString());
    }

    public void testProppatchRemoveJcrData() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "data");
        String propName1 = "jcr:data";
        content.setProperty(propName1, "data");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\" xmlns:jcr=\"jcr:\"><D:set><D:prop><jcr:content><jcr:data/></jcr:content></D:prop></D:set></D:propertyupdate>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropPatchContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropPatchContent.getContentNode(node);
        Property p = content.getProperty(propName1);
        TestPropPatchContent.assertEquals((String)"data", (String)p.getString());
    }

    public void testProppatchSetHierContentProp() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String outerPropName = "webdav:outerProp";
        Node outerPropNode = content.addNode(outerPropName, "exo:outerProp");
        outerPropNode.setProperty("jcr:mimeType", "text/xml");
        outerPropNode.setProperty("jcr:lastModified", Calendar.getInstance());
        outerPropNode.setProperty("jcr:data", "testData");
        String innerProp = "webdav:innerProp";
        outerPropNode.setProperty(innerProp, "innerValue");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:b=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882\" xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\" xmlns:jcr=\"jcr:\"><D:set><D:prop><jcr:content><webdav:outerProp><jcr:data>innerTestValue</jcr:data></webdav:outerProp></jcr:content></D:prop></D:set></D:propertyupdate>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPPATCH", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropPatchContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropPatchContent.getContentNode(node);
        Property innerProperty = content.getNode(outerPropName).getProperty(innerProp);
        TestPropPatchContent.assertEquals((String)"innerTestValue", (String)innerProperty.getValue().getString());
    }

    public static Node getContentNode(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }
}

