/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestMove
extends BaseStandaloneTest {
    private static final String host = "http://localhost:8080";

    public void testMoveForNonCollectionSingleWorkspace() throws Exception {
        this.testMoveForNonCollectionSingleWorkspace(this.getPathWS());
    }

    public void testMoveForNonCollectionSingleWorkspaceWithFakePathWS() throws Exception {
        this.testMoveForNonCollectionSingleWorkspace(this.getFakePathWS());
    }

    private void testMoveForNonCollectionSingleWorkspace(String pathWs) throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + pathWs + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", pathWs + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestMove.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestMove.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestMove.assertEquals((String)content, (String)getContentDest);
        TestMove.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
    }

    public void testMoveForNonCollectionDiferntWorkspaces() throws Exception {
        TestMove.assertNotSame((Object)this.session.getWorkspace().getName(), (Object)this.destSession.getWorkspace().getName());
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathDestWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)this.destSession.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.destSession.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestMove.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestMove.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestMove.assertEquals((String)content, (String)getContentDest);
        TestMove.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
    }

    public void testLocationHeaderInMoveResponse() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)response.getHttpHeaders().containsKey((Object)"Location"));
        TestMove.assertEquals((String)(host + this.getPathWS() + destFilename), (String)response.getHttpHeaders().getFirst((Object)"Location").toString());
    }

    public void testDestinationHeaderParsing() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName() + " test";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        filename = destFilename;
        destFilename = TestUtils.getFileName() + " 'test";
        headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
    }

    public void testNoContentResponses() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, destFilename, inputStream, this.defaultFileNodeType, "");
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        headers.add((Object)"Overwrite", (Object)"T");
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)204, (int)response.getStatus());
    }

    public void testHttpsSchemeInDestinationHeaderParsing() throws Exception {
        String httpsHost = "https://localhost:8080";
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(httpsHost + this.getPathWS() + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
    }

    public void testMoveHeaderBeginsFromWorkspaceName() throws Exception {
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        String destFilename = TestUtils.getFileName();
        filename = (String)filename + "[2]";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestMove.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestMove.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestMove.assertEquals((String)content, (String)getContentDest);
        TestMove.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
    }

    public void testMoveToFolderWithSpace() throws Exception {
        String folderNameWithSpace = "new folder - testMoveToFolderWithSpace";
        this.session.getRootNode().addNode(folderNameWithSpace, "nt:folder");
        this.session.save();
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = "/" + folderNameWithSpace + TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestMove.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestMove.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestMove.assertEquals((String)content, (String)getContentDest);
        TestMove.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
    }

    public void testMoveToFolderWithSpaceUnescapedChars() throws Exception {
        String folderNameWithSpace = "new folder - testMoveToFolderWithSpaceUnescapedChars";
        this.session.getRootNode().addNode(folderNameWithSpace, "nt:folder");
        this.session.save();
        String content = TestUtils.getFileContent();
        Object filename = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)filename));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        TestUtils.addContent((Session)this.session, (String)filename, inputStream, this.defaultFileNodeType, "");
        filename = (String)filename + "[2]";
        String destFilename = TextUtil.unescape((String)("/" + folderNameWithSpace + TestUtils.getFileName()), (char)'%');
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(WORKSPACE + destFilename));
        ContainerResponse response = this.serviceWithEscape("MOVE", this.getPathWS() + (String)filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)201, (int)response.getStatus());
        TestMove.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)destFilename)));
        Node nodeDest = this.session.getRootNode().getNode(TextUtil.relativizePath((String)destFilename));
        TestMove.assertTrue((boolean)nodeDest.hasNode("jcr:content"));
        Node nodeDestContent = nodeDest.getNode("jcr:content");
        TestMove.assertTrue((boolean)nodeDestContent.hasProperty("jcr:data"));
        ByteArrayInputStream streamDest = (ByteArrayInputStream)nodeDestContent.getProperty("jcr:data").getStream();
        String getContentDest = TestUtils.stream2string(streamDest, null);
        TestMove.assertEquals((String)content, (String)getContentDest);
        TestMove.assertFalse((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)filename)));
    }

    public void testMoveToNonCollectionToNonExistingWorkspace() throws Exception {
        String filename = TestUtils.getFileName();
        String destFilename = TestUtils.getFileName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Destination", (Object)(host + this.getPathWS() + destFilename));
        ContainerResponse response = this.service("MOVE", this.getPathWS() + "_" + filename, host, (MultivaluedMap<String, String>)headers, null);
        TestMove.assertEquals((int)409, (int)response.getStatus());
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

