/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.ext;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.proppatch.PropPatchResponseEntity;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestPropFindContent
extends BaseStandaloneTest {
    @Override
    protected String getRepositoryName() {
        return null;
    }

    public void testPropFindNamedProp() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String outerPropName = "webdav:outerProp";
        Node outerPropNode = content.addNode(outerPropName, "exo:outerProp");
        outerPropNode.setProperty("jcr:mimeType", "text/xml");
        outerPropNode.setProperty("jcr:lastModified", Calendar.getInstance());
        outerPropNode.setProperty("jcr:data", "testData");
        String innerProp = "webdav:innerProp";
        outerPropNode.setProperty(innerProp, "innerValue");
        this.session.save();
        String xml = "<D:propfind xmlns:D=\"DAV:\"><D:prop xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><jcr:content xmlns=\"\"><webdav:outerProp xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><webdav:innerProp/></webdav:outerProp></jcr:content></D:prop></D:propfind>";
        String path = node.getPath();
        ContainerResponse response = this.service("PROPFIND", this.getPathWS() + path, "", null, xml.getBytes());
        TestPropFindContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropFindContent.getContentNode(node);
    }

    public void testPropFindAllProp() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String outerPropName = "webdav:outerProp";
        Node outerPropNode = content.addNode(outerPropName, "exo:outerProp");
        outerPropNode.setProperty("jcr:mimeType", "text/xml");
        outerPropNode.setProperty("jcr:lastModified", Calendar.getInstance());
        outerPropNode.setProperty("jcr:data", "testData");
        String innerProp = "webdav:innerProp";
        outerPropNode.setProperty(innerProp, "innerValue");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop/></D:propfind>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"depth", (Object)"1");
        String path = node.getPath();
        ContainerResponse response = this.service("PROPFIND", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, xml.getBytes());
        TestPropFindContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropFindContent.getContentNode(node);
    }

    public void testPropFindPropNames() throws Exception {
        Node node = this.session.getRootNode().addNode("propPatchContentNode", "nt:file");
        Node content = node.addNode("jcr:content", "exo:testContentResource");
        content.setProperty("jcr:mimeType", "text/xml");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", "testData");
        String outerPropName = "webdav:outerProp";
        Node outerPropNode = content.addNode(outerPropName, "exo:outerProp");
        outerPropNode.setProperty("jcr:mimeType", "text/xml");
        outerPropNode.setProperty("jcr:lastModified", Calendar.getInstance());
        outerPropNode.setProperty("jcr:data", "testData");
        String innerProp = "webdav:innerProp";
        outerPropNode.setProperty(innerProp, "innerValue");
        this.session.save();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop/></D:propfind>";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"depth", (Object)"1");
        String path = node.getPath();
        ContainerResponse response = this.service("PROPFIND", this.getPathWS() + path, "", (MultivaluedMap<String, String>)headers, xml.getBytes());
        TestPropFindContent.assertEquals((int)207, (int)response.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropPatchResponseEntity entity = (PropPatchResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        content = TestPropFindContent.getContentNode(node);
    }

    public static Node getContentNode(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }
}

