/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public class TestUnLock
extends BaseStandaloneTest {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.TestUnLock");
    private String path = TestUtils.getFileName();
    private String fileContent = TestUtils.getFileContent();

    @Override
    protected String getRepositoryName() {
        return null;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)this.path));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileContent.getBytes());
        TestUtils.addContent((Session)this.session, this.path, inputStream, this.defaultFileNodeType, "");
        this.path = this.path + "[2]";
    }

    public void testUnLock() throws Exception {
        this.testUnLock(this.getPathWS());
    }

    public void testUnLockWithFakePathWS() throws Exception {
        this.testUnLock(this.getFakePathWS());
    }

    private void testUnLock(String pathWs) throws Exception {
        TestUnLock.assertTrue((boolean)this.session.getRootNode().hasNode(TextUtil.relativizePath((String)this.path)));
        Node lockNode = this.session.getRootNode().getNode(TextUtil.relativizePath((String)this.path));
        String token = TestUtils.lockNode((Session)this.session, this.path, true);
        TestUnLock.assertTrue((boolean)lockNode.isLocked());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"lock-token", (Object)token);
        ContainerResponse containerResponse = this.serviceWithEscape("UNLOCK", pathWs + this.path, "", (MultivaluedMap<String, String>)headers, null);
        TestUnLock.assertEquals((int)204, (int)containerResponse.getStatus());
    }
}

