/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MkColCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.MkColCommand");
    private final NullResourceLocksHolder nullResourceLocks;
    private final UriBuilder uriBuilder;

    public MkColCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
        this.uriBuilder = null;
    }

    public MkColCommand(NullResourceLocksHolder nullResourceLocks, UriBuilder uriBuilder) {
        this.nullResourceLocks = nullResourceLocks;
        this.uriBuilder = uriBuilder;
    }

    public Response mkCol(Session session, String path, String nodeType, List<String> mixinTypes, List<String> tokens) {
        try {
            this.nullResourceLocks.checkLock(session, path, tokens);
            Node node = session.getRootNode().addNode(TextUtil.relativizePath(path), nodeType);
            path = node.getPath();
            if (mixinTypes != null) {
                this.addMixins(node, mixinTypes);
            }
            session.save();
        }
        catch (ItemExistsException exc) {
            return Response.status((int)405).entity((Object)exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (AccessDeniedException exc) {
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
        if (this.uriBuilder != null) {
            return Response.created((URI)this.uriBuilder.path(session.getWorkspace().getName()).path(path).build(new Object[0])).build();
        }
        return Response.status((int)201).build();
    }

    private void addMixins(Node node, List<String> mixinTypes) {
        for (int i = 0; i < mixinTypes.size(); ++i) {
            String curMixinType = mixinTypes.get(i);
            try {
                node.addMixin(curMixinType);
                continue;
            }
            catch (Exception exc) {
                log.error((Object)("Can't add mixin [" + curMixinType + "]"), (Throwable)exc);
            }
        }
    }
}

