/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.resolving.impl;

import java.io.IOException;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLResolver
implements EntityResolver {
    private Map<String, String> publicIDs_;
    private Map<String, String> systemIDs_;
    private boolean publicIDPrefer_ = false;

    public XMLResolver(Map<String, String> publicIDs, Map<String, String> systemIDs) {
        this.publicIDs_ = publicIDs;
        this.systemIDs_ = systemIDs;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String entity = null;
        if (this.publicIDPrefer_ && publicId != null && publicId.length() != 0) {
            entity = this.publicIDs_.get(publicId);
        }
        if (entity == null && systemId != null && systemId.length() != 0) {
            entity = this.systemIDs_.get(systemId);
        }
        if (entity == null && publicId != null && publicId.length() != 0) {
            entity = this.publicIDs_.get(publicId);
        }
        if (entity != null && this.getClass().getResource(entity) != null) {
            InputSource src = new InputSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(entity));
            src.setSystemId(Thread.currentThread().getContextClassLoader().getResource(entity).getPath());
            return src;
        }
        return null;
    }

    public boolean isPublicIDPrefer() {
        return this.publicIDPrefer_;
    }

    public void setPublicIDPrefer(boolean publicPrefer) {
        this.publicIDPrefer_ = publicPrefer;
    }
}

