/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.lock;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.util.IdGenerator;

public class NullResourceLocksHolder {
    private final HashMap<String, String> nullResourceLocks = new HashMap();

    public String addLock(Session session, String path) throws LockException {
        String repoPath = session.getRepository().hashCode() + "/" + session.getWorkspace().getName() + "/" + path;
        if (!this.nullResourceLocks.containsKey(repoPath)) {
            String newLockToken = IdGenerator.generate();
            session.addLockToken(newLockToken);
            this.nullResourceLocks.put(repoPath, newLockToken);
            return newLockToken;
        }
        String currentToken = this.nullResourceLocks.get(repoPath);
        for (String t : session.getLockTokens()) {
            if (!t.equals(currentToken)) continue;
            return t;
        }
        throw new LockException("Resource already locked " + repoPath);
    }

    public void removeLock(Session session, String path) {
        String repoPath = session.getRepository().hashCode() + "/" + session.getWorkspace().getName() + "/" + path;
        String token = this.nullResourceLocks.get(repoPath);
        session.removeLockToken(token);
        this.nullResourceLocks.remove(repoPath);
    }

    public boolean isLocked(Session session, String path) {
        String repoPath = session.getRepository().hashCode() + "/" + session.getWorkspace().getName() + "/" + path;
        return this.nullResourceLocks.get(repoPath) != null;
    }

    public void checkLock(Session session, String path, List<String> tokens) throws LockException {
        String repoPath = session.getRepository().hashCode() + "/" + session.getWorkspace().getName() + "/" + path;
        String currentToken = this.nullResourceLocks.get(repoPath);
        if (currentToken == null) {
            return;
        }
        if (tokens != null) {
            for (String token : tokens) {
                if (!token.equals(currentToken)) continue;
                return;
            }
        }
        throw new LockException("Resource already locked " + repoPath);
    }
}

