/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.connectors.jcr.ejb30;

import java.io.IOException;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.exoplatform.connectors.jcr.ejb30.JcrRestEJBConnectorLocal;
import org.exoplatform.connectors.jcr.ejb30.JcrRestEJBConnectorRemote;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ext.transport.SerialRequest;
import org.exoplatform.services.rest.ext.transport.SerialResponse;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.ws.rest.ejbconnector30.RestEJBConnectorLocal;

@Stateless
@DeclareRoles(value={"admin", "users"})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class JcrRestEJBConnector
implements JcrRestEJBConnectorRemote,
JcrRestEJBConnectorLocal {
    private static final Log LOG = ExoLogger.getLogger((String)JcrRestEJBConnector.class.getName());
    private static final String JNDI_NAME = "org.exoplatform.ws.rest.ejbconnector30.RestEJBConnector_" + RestEJBConnectorLocal.class.getName() + "@Local";
    @Resource
    private SessionContext context;
    private String containerName;

    @RolesAllowed(value={"admin", "users"})
    public final SerialResponse service(SerialRequest request) throws IOException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.containerName = (String)ctx.lookup("java:comp/env/exo.container.name");
        }
        catch (NamingException e1) {
            LOG.error((Object)"Can't construct an initial context or get portal container name. ");
        }
        ExoContainer container = this.getContainer();
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        ThreadLocalSessionProviderService sessionProviderService = (ThreadLocalSessionProviderService)container.getComponentInstanceOfType(ThreadLocalSessionProviderService.class);
        String userId = this.context.getCallerPrincipal().getName();
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
            try {
                identity = authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                throw new EJBException("Can't create identity for user " + userId, e);
            }
        }
        try {
            ConversationState state = new ConversationState(identity);
            SessionProvider provider = new SessionProvider(state);
            state.setAttribute("JCRsessionProvider", (Object)provider);
            ConversationState.setCurrent((ConversationState)state);
            sessionProviderService.setSessionProvider(null, provider);
            if (ctx != null) {
                RestEJBConnectorLocal bean = (RestEJBConnectorLocal)ctx.lookup(JNDI_NAME);
                SerialResponse serialResponse = bean.service(request);
                return serialResponse;
            }
            try {
                throw new EJBException("Can't get local interface of RestEJBConnector, InitialContext is null. ");
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
        finally {
            try {
                sessionProviderService.removeSessionProvider(null);
                ConversationState.setCurrent(null);
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed reset ThreadLocal variables", (Throwable)e);
            }
        }
    }

    protected ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.containerName);
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
        }
        return container;
    }
}

