/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class JCRCommandHelper {
    public static Node createResourceFile(Node parentNode, String relPath, Object data, String mimeType) throws Exception {
        Node file = parentNode.addNode(relPath, "nt:file");
        Node contentNode = file.addNode("jcr:content", "nt:resource");
        if (data instanceof InputStream) {
            contentNode.setProperty("jcr:data", (InputStream)data);
        } else if (data instanceof String) {
            contentNode.setProperty("jcr:data", (String)data);
        } else {
            throw new Exception("Invalid object for jcr:data " + String.valueOf(data));
        }
        contentNode.setProperty("jcr:mimeType", mimeType);
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        return file;
    }

    public static Node getNtResourceRecursively(Node node) throws ItemNotFoundException, RepositoryException {
        if (node.isNodeType("nt:resource")) {
            return node;
        }
        Item pi = node.getPrimaryItem();
        if (pi.isNode()) {
            return JCRCommandHelper.getNtResourceRecursively((Node)pi);
        }
        throw new ItemNotFoundException("No nt:resource node found for " + node.getPath());
    }
}

