/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;

public class GetContextInfoCommand
extends AbstractCliCommand {
    @Override
    public boolean perform(CliAppContext ctx) {
        StringBuilder output = new StringBuilder();
        try {
            output.append("Context info: \n");
            Item item = ctx.getCurrentItem();
            Object itemDefinition = item.isNode() ? ((NodeImpl)item).getDefinition() : ((PropertyImpl)item).getDefinition();
            output.append("username: ").append(ctx.getUserName()).append("\n");
            output.append("workspace: ").append(ctx.getCurrentWorkspace()).append("\n");
            output.append("item path: ").append(item.getPath()).append("\n");
            output.append("item type: ").append(item.isNode() ? "Node" : "Property").append("\n");
            output.append("item definitions:\n");
            output.append("  name: ").append(itemDefinition.getName()).append("\n");
            output.append("  autocreated:").append(itemDefinition.isAutoCreated()).append("\n");
            output.append("  mandatory:").append(itemDefinition.isMandatory()).append("\n");
            output.append("  protected:").append(itemDefinition.isProtected()).append("\n");
            output.append("  onparentversion:").append(itemDefinition.getOnParentVersion()).append("\n");
            if (!item.isNode()) {
                Property property = (Property)item;
                int propertyType = property.getValue().getType();
                if (propertyType != 2) {
                    PropertyDefinition propertyDefinition = (PropertyDefinition)itemDefinition;
                    if (!propertyDefinition.isMultiple()) {
                        output.append("property value:").append(property.getValue().getString()).append("\n");
                    } else {
                        output.append("property value is multiple\n");
                    }
                } else {
                    output.append("can't show property value:\n");
                }
            }
            output.append("parameters:\n");
            Iterator<String> parametersIterator = ctx.getParameters().iterator();
            int i = 0;
            while (parametersIterator.hasNext()) {
                output.append("  [").append(i).append("] : ").append(parametersIterator.next()).append("\n");
                ++i;
            }
        }
        catch (Exception e) {
            output.append("Can't execute command - ").append(e.getMessage()).append("\n");
        }
        ctx.setOutput(output.toString());
        return false;
    }
}

