/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.commands;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.frameworks.ftpclient.FtpUtils;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FtpCommandImpl
implements FtpCommand {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.FtpCommandImpl");
    protected FtpClientSession clientSession;
    protected int replyCode;
    protected String descript = "";

    public int run(FtpClientSession clientSession) {
        this.clientSession = clientSession;
        int status = this.execute();
        return status;
    }

    public abstract int execute();

    public void sendCommand(String command) {
        LOG.info((Object)(">>> " + command));
        try {
            byte[] data = command.getBytes();
            OutputStream outStream = this.clientSession.getClientSocket().getOutputStream();
            outStream.write(data);
            outStream.write("\r\n".getBytes());
        }
        catch (IOException exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    private boolean isReplyString(String replyString) {
        if (replyString.length() < 4) {
            return false;
        }
        return replyString.charAt(0) >= '0' && replyString.charAt(0) <= '9' && replyString.charAt(1) >= '0' && replyString.charAt(1) <= '9' && replyString.charAt(2) >= '0' && replyString.charAt(2) <= '9' && replyString.charAt(3) == ' ';
    }

    public int getReply() throws Exception {
        LOG.info((Object)"try get reply..........");
        StringBuilder reply = new StringBuilder();
        String curReply = "";
        while (true) {
            if ("".equals(curReply = this.readLine())) {
                reply.append("\r\n");
                continue;
            }
            reply.append(curReply);
            if (this.isReplyString(curReply)) break;
            reply.append("\r\n");
        }
        this.descript = reply.toString();
        this.replyCode = FtpUtils.getReplyCode(curReply);
        LOG.info((Object)("<<< " + this.descript));
        return this.replyCode;
    }

    public String getDescription() {
        return this.descript;
    }

    public String readLine() throws Exception {
        byte[] buffer = new byte[4096];
        int bufPos = 0;
        int prevByte = 0;
        int received;
        while ((received = this.clientSession.getClientSocket().getInputStream().read()) >= 0) {
            buffer[bufPos] = (byte)received;
            ++bufPos;
            if (prevByte == 13 && received == 10) {
                StringBuilder resultLine = new StringBuilder();
                for (int i = 0; i < bufPos - 2; ++i) {
                    resultLine.append((char)buffer[i]);
                }
                return resultLine.toString();
            }
            prevByte = (byte)received;
        }
        return null;
    }
}

