/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpDataTransiverImpl
implements FtpDataTransiver {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.FtpDataTransiverImpl");
    protected Socket dataSocket = null;
    protected Thread connectionThread;

    public void OpenPassive(String host, int port) {
        this.connectionThread = new PassiveThread(host, port);
        this.connectionThread.start();
    }

    public boolean OpenActive(int port) {
        try {
            this.connectionThread = new ActiveThread(port);
            this.connectionThread.start();
            return true;
        }
        catch (Exception exc) {
            LOG.info((Object)("Can't open active mode. PORT is busy. " + exc.getMessage()), (Throwable)exc);
            return false;
        }
    }

    public boolean isConnected() {
        if (this.dataSocket == null) {
            return false;
        }
        return this.dataSocket.isConnected();
    }

    public void close() {
        try {
            if (this.connectionThread != null) {
                this.connectionThread.stop();
            }
            if (this.dataSocket != null && this.dataSocket.isConnected()) {
                this.dataSocket.close();
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    public byte[] receive() {
        if (this.dataSocket == null) {
            return null;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            int readed;
            byte[] buffer = new byte[4096];
            while (this.dataSocket.isConnected() && (readed = this.dataSocket.getInputStream().read(buffer)) >= 0) {
                outStream.write(buffer, 0, readed);
                Thread.sleep(10L);
            }
        }
        catch (SocketException exc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + exc.getMessage()));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
        }
        try {
            if (this.dataSocket.isConnected()) {
                this.dataSocket.close();
            }
        }
        catch (IOException exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        return outStream.toByteArray();
    }

    public boolean send(byte[] data) {
        if (this.dataSocket != null) {
            try {
                this.dataSocket.getOutputStream().write(data);
                this.dataSocket.close();
                return true;
            }
            catch (IOException exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
        return false;
    }

    protected class ActiveThread
    extends Thread {
        private Log activeLog = ExoLogger.getLogger((String)"exo.jcr.framework.command.ActiveThread");
        protected int port;
        protected ServerSocket serverSocket;

        public ActiveThread(int port) throws Exception {
            this.port = port;
            this.serverSocket = new ServerSocket(port);
        }

        public void run() {
            try {
                FtpDataTransiverImpl.this.dataSocket = this.serverSocket.accept();
                this.serverSocket.close();
            }
            catch (Exception exc) {
                this.activeLog.info((Object)("Can't open ACTIVE mode. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    protected class PassiveThread
    extends Thread {
        private Log passiveLog = ExoLogger.getLogger((String)"exo.jcr.framework.command.PassiveThread");
        protected String host;
        protected int port;

        public PassiveThread(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public void run() {
            FtpDataTransiverImpl.this.dataSocket = new Socket();
            InetSocketAddress sockAddr = new InetSocketAddress(this.host, this.port);
            try {
                FtpDataTransiverImpl.this.dataSocket.connect(sockAddr);
            }
            catch (Exception exc) {
                this.passiveLog.info((Object)("Can't open PASSIVE mode. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

