/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.data;

import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpSlowInputStream1
extends InputStream {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.FtpSlowInputStream");
    protected InputStream nativeInputStream;
    protected int bytesPerSec;
    protected int blockSize = 0;
    protected int readed = 0;

    public FtpSlowInputStream1(InputStream nativeInputStream, int bytesPerSec) {
        this.nativeInputStream = nativeInputStream;
        this.bytesPerSec = bytesPerSec;
        this.blockSize = bytesPerSec / 10;
    }

    protected void tryWaiting() {
        if (this.readed >= this.blockSize) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception until Thread.sleep(...). " + exc.getMessage()), (Throwable)exc);
            }
            this.readed = 0;
        }
    }

    public int read() throws IOException {
        this.tryWaiting();
        int curReaded = this.nativeInputStream.read();
        if (curReaded >= 0) {
            ++this.readed;
        }
        return curReaded;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int size) throws IOException {
        this.tryWaiting();
        int curBlockSize = this.blockSize - this.readed;
        if (curBlockSize > size) {
            curBlockSize = size;
        }
        int curReaded = this.nativeInputStream.read(buffer, offset, curBlockSize);
        this.readed += curReaded;
        return curReaded;
    }

    public long skip(long skipVal) throws IOException {
        return this.nativeInputStream.skip(skipVal);
    }

    public int available() throws IOException {
        return this.nativeInputStream.available();
    }

    public void close() throws IOException {
        this.nativeInputStream.close();
    }

    public synchronized void mark(int markVal) {
        this.nativeInputStream.mark(markVal);
    }

    public synchronized void reset() throws IOException {
        this.nativeInputStream.reset();
    }

    public boolean markSupported() {
        return this.nativeInputStream.markSupported();
    }
}

