/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.frameworks.ftpclient.data.FtpDataTransiver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpClientSessionImpl
implements FtpClientSession {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.FtpClientSessionImpl");
    protected String host;
    protected int port;
    protected Socket clientSocket = null;
    protected String systemType;
    protected FtpDataTransiver dataTransiver = null;

    public FtpClientSessionImpl(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public boolean connect() throws Exception {
        return this.connect(1);
    }

    @Override
    public boolean connect(int attemptsCount) throws Exception {
        Throwable prevExc = null;
        for (int i = 0; i < attemptsCount; ++i) {
            try {
                this.clientSocket = new Socket();
                InetSocketAddress sockAddr = new InetSocketAddress(this.host, this.port);
                this.clientSocket.connect(sockAddr);
                boolean connected = false;
                for (int wi = 0; wi < 200; ++wi) {
                    if (this.clientSocket.isConnected()) {
                        connected = true;
                        break;
                    }
                    Thread.sleep(1L);
                }
                if (!connected) {
                    throw new Exception();
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                String reply = "";
                while (reply != null && !reply.startsWith("220 ")) {
                    reply = br.readLine();
                }
                return true;
            }
            catch (Exception exc) {
                prevExc = exc;
                Thread.sleep(3000L);
                continue;
            }
        }
        LOG.info((Object)("unhandled exception. " + prevExc.getMessage()), prevExc);
        return false;
    }

    @Override
    public void close() {
        try {
            if (this.dataTransiver != null) {
                this.dataTransiver.close();
            }
            if (this.clientSocket == null) {
                return;
            }
            if (this.clientSocket.isConnected()) {
                this.clientSocket.close();
            }
        }
        catch (IOException exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }

    @Override
    public Socket getClientSocket() {
        return this.clientSocket;
    }

    @Override
    public int executeCommand(FtpCommand command) throws Exception {
        if (this.clientSocket == null) {
            return -1;
        }
        return command.run(this);
    }

    @Override
    public int executeCommand(FtpCommand command, int expectReply, int attemptsCount) throws Exception {
        int reply = -1;
        for (int i = 0; i < attemptsCount; ++i) {
            reply = command.run(this);
            if (reply == expectReply) {
                return reply;
            }
            Thread.sleep(100L);
        }
        return reply;
    }

    @Override
    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    @Override
    public String getSystemType() {
        return this.systemType;
    }

    @Override
    public void setDataTransiver(FtpDataTransiver dataTransiver) {
        this.dataTransiver = dataTransiver;
    }

    @Override
    public FtpDataTransiver getDataTransiver() {
        return this.dataTransiver;
    }
}

