/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.ftpclient;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.exoplatform.frameworks.ftpclient.FtpTestConfig;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSession;
import org.exoplatform.frameworks.ftpclient.client.FtpClientSessionImpl;
import org.exoplatform.frameworks.ftpclient.commands.CmdList;
import org.exoplatform.frameworks.ftpclient.commands.CmdMkd;
import org.exoplatform.frameworks.ftpclient.commands.CmdPass;
import org.exoplatform.frameworks.ftpclient.commands.CmdPasv;
import org.exoplatform.frameworks.ftpclient.commands.CmdRetr;
import org.exoplatform.frameworks.ftpclient.commands.CmdRmd;
import org.exoplatform.frameworks.ftpclient.commands.CmdStor;
import org.exoplatform.frameworks.ftpclient.commands.CmdSyst;
import org.exoplatform.frameworks.ftpclient.commands.CmdType;
import org.exoplatform.frameworks.ftpclient.commands.CmdUser;
import org.exoplatform.frameworks.ftpclient.commands.FtpCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MultiThreadFtpTest
extends TestCase {
    public static final int ITEMS_COUNT = 3;
    public static final int CLIENTS_COUNT = 10;

    public void testMultiThread() throws Exception {
        FtpThreadTest curTest;
        Log log = ExoLogger.getLogger((String)"exo.jcr.framework.command.MultiThreadFtpTest");
        log.info((Object)"Test...");
        ArrayList<FtpThreadTest> testers = new ArrayList<FtpThreadTest>();
        for (int i = 0; i < 10; ++i) {
            String testFolder = "/production/test_folder_" + i;
            curTest = new FtpThreadTest(testFolder);
            testers.add(curTest);
            curTest.start();
        }
        try {
            boolean enable = true;
            while (enable) {
                enable = false;
                for (int i = 0; i < testers.size(); ++i) {
                    curTest = (FtpThreadTest)testers.get(i);
                    if (!curTest.isAlive()) continue;
                    enable = true;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled ecxeption. " + exc.getMessage()), (Throwable)exc);
        }
        log.info((Object)"Complete.");
    }

    protected class FtpThreadTest
    extends Thread {
        protected Log log = ExoLogger.getLogger((String)("exo.jcr.framework.command." + this));
        protected String testFolder;

        public FtpThreadTest(String testFolder) {
            this.testFolder = testFolder;
        }

        protected void createFolders(String rootTestFolder) {
            try {
                FtpClientSession client = FtpTestConfig.getTestFtpClient();
                client.connect();
                TestCase.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
                TestCase.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
                TestCase.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
                TestCase.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdType("A")));
                TestCase.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
                this.log.info((Object)"Verify folder exists...");
                if (client.executeCommand((FtpCommand)new CmdList(rootTestFolder)) == 226) {
                    this.log.info((Object)"Test folder exist. try delete it...");
                    TestCase.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd(rootTestFolder)));
                    this.log.info((Object)"Deleted.");
                }
                for (int i1 = 1; i1 <= 3; ++i1) {
                    String folder1 = rootTestFolder + "/folder_" + i1;
                    TestCase.assertEquals((int)257, (int)client.executeCommand((FtpCommand)new CmdMkd(folder1)));
                    for (int i2 = 1; i2 <= 3; ++i2) {
                        Object folder2 = folder1.substring(0);
                        folder2 = (String)folder2 + "/subfolder_" + i2;
                        TestCase.assertEquals((int)257, (int)client.executeCommand((FtpCommand)new CmdMkd((String)folder2)));
                        for (int i3 = 0; i3 < 3; ++i3) {
                            TestCase.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
                            Object file3 = ((String)folder2).substring(0);
                            file3 = (String)file3 + "/test_file_" + i3 + ".txt";
                            CmdStor cmdStor = new CmdStor((String)file3);
                            byte[] fileData = new byte[1024];
                            for (int c = 0; c < 1024; ++c) {
                                fileData[c] = 65;
                                int n = c;
                                byte by = (byte)(fileData[n] + (byte)i3);
                                fileData[n] = by;
                                fileData[c] = by;
                            }
                            cmdStor.setFileContent(fileData);
                            TestCase.assertEquals((int)226, (int)client.executeCommand((FtpCommand)cmdStor));
                            this.log.info((Object)("File [" + (String)file3 + "] created"));
                        }
                    }
                }
                client.close();
            }
            catch (Exception exc) {
                this.log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }

        public void readAllFolders(String rootTestFolder) {
            try {
                FtpClientSessionImpl client = new FtpClientSessionImpl("127.0.0.1", 21);
                client.connect();
                TestCase.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
                TestCase.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
                TestCase.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
                TestCase.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdType("A")));
                for (int i1 = 1; i1 <= 3; ++i1) {
                    String folder1 = rootTestFolder + "/folder_" + i1;
                    for (int i2 = 1; i2 <= 3; ++i2) {
                        Object folder2 = folder1.substring(0);
                        folder2 = (String)folder2 + "/subfolder_" + i2;
                        for (int i3 = 0; i3 < 3; ++i3) {
                            Object file3 = ((String)folder2).substring(0);
                            file3 = (String)file3 + "/test_file_" + i3 + ".txt";
                            this.log.info((Object)("CurFileName - [" + (String)file3 + "]"));
                            TestCase.assertEquals((int)227, (int)client.executeCommand((FtpCommand)new CmdPasv()));
                            CmdRetr cmdRetr = new CmdRetr((String)file3);
                            int reply = client.executeCommand((FtpCommand)cmdRetr);
                            this.log.info((Object)("RETR REPLY - " + reply));
                        }
                    }
                }
                client.close();
            }
            catch (Exception exc) {
                this.log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }

        public void removeAllFolders(String rootTestFolder) {
            this.log.info((Object)"Clearing...");
            try {
                FtpClientSessionImpl client = new FtpClientSessionImpl("127.0.0.1", 21);
                client.connect();
                TestCase.assertEquals((int)331, (int)client.executeCommand((FtpCommand)new CmdUser("admin")));
                TestCase.assertEquals((int)230, (int)client.executeCommand((FtpCommand)new CmdPass("admin")));
                TestCase.assertEquals((int)215, (int)client.executeCommand((FtpCommand)new CmdSyst()));
                TestCase.assertEquals((int)200, (int)client.executeCommand((FtpCommand)new CmdType("A")));
                for (int i1 = 1; i1 <= 3; ++i1) {
                    String folder1 = rootTestFolder + "/folder_" + i1;
                    for (int i2 = 1; i2 <= 3; ++i2) {
                        Object folder2 = folder1.substring(0);
                        folder2 = (String)folder2 + "/subfolder_" + i2;
                        for (int i3 = 0; i3 < 3; ++i3) {
                            Object file3 = ((String)folder2).substring(0);
                            file3 = (String)file3 + "/test_file_" + i3 + ".txt";
                            this.log.info((Object)("Try delete [" + (String)file3 + "]..."));
                            TestCase.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd((String)file3)));
                        }
                        this.log.info((Object)("Try delete [" + (String)folder2 + "]..."));
                        TestCase.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd((String)folder2)));
                    }
                    this.log.info((Object)("Try delete [" + folder1 + "]..."));
                    TestCase.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd(folder1)));
                }
                TestCase.assertEquals((int)250, (int)client.executeCommand((FtpCommand)new CmdRmd(rootTestFolder)));
                client.close();
            }
            catch (Exception exc) {
                this.log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
            this.log.info((Object)"Complete.");
        }

        @Override
        public void run() {
            this.log.info((Object)"Start test...");
            this.createFolders(this.testFolder);
            this.readAllFolders(this.testFolder);
            this.removeAllFolders(this.testFolder);
            this.log.info((Object)"Test complete.");
        }
    }
}

