/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;

public class PortalContainerInitializedFilter
implements Filter {
    private static Log log = ExoLogger.getLogger((String)"PortatContainerInitializedFilter");
    private String contextName;

    public void init(FilterConfig config) throws ServletException {
        this.contextName = config.getServletContext().getServletContextName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PortalContainer pcontainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.contextName);
        if (log.isDebugEnabled()) {
            log.debug((Object)"get-by-name");
        }
        if (pcontainer == null) {
            ExoContainer container;
            if (log.isInfoEnabled()) {
                log.info((Object)"get-from-root");
            }
            if ((container = ExoContainerContext.getTopContainer()) instanceof RootContainer) {
                pcontainer = ((RootContainer)container).getPortalContainer(this.contextName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"PortalContainer is created after RootContainer");
                }
            }
        }
        if (pcontainer == null) {
            throw new ServletException("Could not initialize PortalContainer.Current ExoContainer is: " + ExoContainerContext.getCurrentContainer());
        }
        try {
            PortalContainer.setInstance((PortalContainer)pcontainer);
            chain.doFilter(request, response);
        }
        finally {
            try {
                PortalContainer.setInstance(null);
            }
            catch (Exception e) {
                log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }
}

