/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.request;

import java.util.ArrayList;
import org.exoplatform.frameworks.webdavclient.request.NameSpaceRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyList {
    protected ArrayList<String> properties = new ArrayList();
    protected NameSpaceRegistry nsRegistry = new NameSpaceRegistry();
    protected boolean isPropNames = false;

    public void setProperty(String name, String nameSpace) {
        if (this.nsRegistry.registerNameSpace(name, nameSpace)) {
            this.properties.add(name);
        } else {
            this.properties.add("A:" + name);
        }
    }

    public void clearProperies() {
        this.properties.clear();
        this.nsRegistry.clearNameSpaces();
    }

    public boolean isAllProp() {
        return this.properties.size() == 0;
    }

    public void isPropNamesRequired(boolean isPropNames) {
        this.isPropNames = isPropNames;
    }

    public Element toXml(Document xmlDocument) {
        if (this.isPropNames) {
            return xmlDocument.createElement("A:propname");
        }
        if (this.isAllProp()) {
            return xmlDocument.createElement("A:allprop");
        }
        Element propEl = xmlDocument.createElement("A:prop");
        this.nsRegistry.fillNameSpaces(propEl);
        for (int i = 0; i < this.properties.size(); ++i) {
            String curPropName = this.properties.get(i);
            Element curPropEl = xmlDocument.createElement(curPropName);
            propEl.appendChild(curPropEl);
        }
        return propEl;
    }
}

