/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.properties;

import org.exoplatform.frameworks.webdavclient.http.Log;
import org.exoplatform.frameworks.webdavclient.properties.CommonProp;
import org.exoplatform.frameworks.webdavclient.properties.PropApi;
import org.w3c.dom.Node;

public class PropManager {
    protected static String[][] availableProperties = new String[][]{{"displayname", "org.exoplatform.frameworks.webdavclient.properties.DisplayNameProp"}, {"lockdiscovery", "org.exoplatform.frameworks.webdavclient.properties.LockDiscoveryProp"}, {"resourcetype", "org.exoplatform.frameworks.webdavclient.properties.ResourceTypeProp"}, {"getcontenttype", "org.exoplatform.frameworks.webdavclient.properties.ContentTypeProp"}, {"getcontentlength", "org.exoplatform.frameworks.webdavclient.properties.ContentLengthProp"}, {"getlastmodified", "org.exoplatform.frameworks.webdavclient.properties.LastModifiedProp"}, {"checked-in", "org.exoplatform.frameworks.webdavclient.properties.CheckedInProp"}, {"checked-out", "org.exoplatform.frameworks.webdavclient.properties.CheckedOutProp"}, {"version-name", "org.exoplatform.frameworks.webdavclient.properties.VersionNameProp"}, {"creator-displayname", "org.exoplatform.frameworks.webdavclient.properties.CreatorDisplayNameProp"}, {"supportedlock", "org.exoplatform.frameworks.webdavclient.properties.SupportedLockProp"}, {"supported-query-grammar-set", "org.exoplatform.frameworks.webdavclient.properties.SupportedQueryGrammarSetProp"}, {"supported-method-set", "org.exoplatform.frameworks.webdavclient.properties.SupportedMethodSetProp"}, {"current-user-privilege-set", "org.exoplatform.frameworks.webdavclient.properties.CurrentUserPrivilegeSet"}, {"creationdate", "org.exoplatform.frameworks.webdavclient.properties.CreationDateProp"}};

    public static PropApi getPropertyByNode(Node propertyNode, String httpStatus) {
        try {
            String nodeName = propertyNode.getLocalName();
            if (!propertyNode.getNamespaceURI().equals("DAV:")) {
                nodeName = propertyNode.getNodeName();
            }
            PropApi curProp = null;
            for (int i = 0; i < availableProperties.length; ++i) {
                if (!nodeName.equals(availableProperties[i][0])) continue;
                curProp = (PropApi)Class.forName(availableProperties[i][1]).newInstance();
                break;
            }
            if (curProp == null) {
                curProp = new CommonProp(nodeName);
            }
            curProp.setStatus(httpStatus);
            curProp.init(propertyNode);
            return curProp;
        }
        catch (Exception exc) {
            Log.info("Unhandled exception. ", exc);
            return null;
        }
    }
}

