/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.xmlexport;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.frameworks.webdavclient.commands.DavCommand;
import org.exoplatform.frameworks.webdavclient.xmlexport.XmlItemDescription;
import org.exoplatform.frameworks.webdavclient.xmlexport.XmlNodeDescription;
import org.exoplatform.frameworks.webdavclient.xmlexport.XmlPropertyDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JcrXmlContent {
    public static final int TYPE_NODE = 1;
    public static final int TYPE_PROPERTY = 2;
    private XmlItemDescription itemDescription;
    private int type;

    public JcrXmlContent(DavCommand webDavCommand) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        byte[] xmlData = webDavCommand.getResponseDataBuffer();
        Document document = builder.parse(new ByteArrayInputStream(xmlData));
        NodeList nodeList = document.getChildNodes();
        Node rootNode = nodeList.item(0);
        if ("node".equals(rootNode.getLocalName())) {
            this.itemDescription = new XmlNodeDescription(rootNode);
            this.type = 1;
        } else if ("property".equals(rootNode.getLocalName())) {
            this.itemDescription = new XmlPropertyDescription(rootNode);
            this.type = 2;
        }
    }

    public boolean isNode() {
        return this.type == 1;
    }

    public boolean isProperty() {
        return this.type == 2;
    }

    public XmlItemDescription getItemDescription() {
        return this.itemDescription;
    }
}

