/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)"exo.jcr.component.core.DirectoryHelper");

    public static List<File> listFiles(File srcPath) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        if (!srcPath.isDirectory()) {
            throw new IOException(srcPath.getAbsolutePath() + " is a directory");
        }
        for (File subFile : srcPath.listFiles()) {
            result.add(subFile);
            if (!subFile.isDirectory()) continue;
            result.addAll(DirectoryHelper.listFiles(subFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdirs();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                DirectoryHelper.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(srcPath);
                out = new FileOutputStream(dstPath);
                DirectoryHelper.transfer(in, out);
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
    }

    public static void removeDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            for (File subFile : dir.listFiles()) {
                DirectoryHelper.removeDirectory(subFile);
            }
            if (!dir.delete()) {
                throw new IOException("Can't remove folder : " + dir.getCanonicalPath());
            }
        } else if (!dir.delete()) {
            throw new IOException("Can't remove file : " + dir.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressDirectory(File rootPath, File dstZipPath) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(dstZipPath));
        try {
            if (rootPath.isDirectory()) {
                String[] files = rootPath.list();
                if (files == null || files.length == 0) {
                    throw new ZipException("ZIP file must have at least one entry");
                }
                for (int i = 0; i < files.length; ++i) {
                    DirectoryHelper.compressDirectory("", new File(rootPath, files[i]), zip);
                }
            } else {
                DirectoryHelper.compressDirectory("", rootPath, zip);
            }
        }
        finally {
            if (zip != null) {
                zip.flush();
                zip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressDirectory(String relativePath, File srcPath, ZipOutputStream zip) throws IOException {
        if (srcPath.isDirectory()) {
            zip.putNextEntry(new ZipEntry(relativePath + "/" + srcPath.getName() + "/"));
            zip.closeEntry();
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                DirectoryHelper.compressDirectory(relativePath + "/" + srcPath.getName(), new File(srcPath, files[i]), zip);
            }
        } else {
            try (FileInputStream in = new FileInputStream(srcPath);){
                zip.putNextEntry(new ZipEntry(relativePath + "/" + srcPath.getName()));
                DirectoryHelper.transfer(in, zip);
                zip.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressDirectory(File srcZipPath, File dstDirPath) throws IOException {
        ZipEntry entry = null;
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(srcZipPath));){
            while ((entry = in.getNextEntry()) != null) {
                File dstFile = new File(dstDirPath, entry.getName());
                dstFile.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                try (FileOutputStream out = new FileOutputStream(dstFile);){
                    DirectoryHelper.transfer(in, out);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressEveryFileFromDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdirs();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                DirectoryHelper.uncompressEveryFileFromDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else {
            ZipInputStream in = null;
            OutputStream out = null;
            try {
                in = new ZipInputStream(new FileInputStream(srcPath));
                in.getNextEntry();
                out = new FileOutputStream(dstPath);
                DirectoryHelper.transfer(in, out);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[2048];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public static void deleteDstAndRename(File srcFile, File dstFile) throws IOException {
        if (dstFile.exists() && !dstFile.delete()) {
            throw new IOException("Cannot delete " + dstFile);
        }
        DirectoryHelper.renameFile(srcFile, dstFile);
    }

    public static void renameFile(File srcFile, File dstFile) throws IOException {
        if (!srcFile.renameTo(dstFile)) {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(srcFile);
                out = new FileOutputStream(dstFile);
                DirectoryHelper.transfer(in, out);
            }
            catch (IOException ioe) {
                IOException newExc = new IOException("Cannot rename " + srcFile + " to " + dstFile);
                newExc.initCause(ioe);
                throw newExc;
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            srcFile.delete();
        }
    }

    public static long getSize(File dir) {
        long size = 0L;
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                size += file.length();
                continue;
            }
            size += DirectoryHelper.getSize(file);
        }
        return size;
    }

    public static void safeClose(Closeable obj) {
        try {
            obj.close();
        }
        catch (IOException e) {
            LOG.error("Error while closing " + obj, (Throwable)e);
        }
    }
}

