/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;

class CommittableIndexReader
extends FilterIndexReader {
    private final AtomicLong modCount;
    private final boolean transientDeletions;
    private final Set<Integer> deletedDocs;

    CommittableIndexReader(IndexReader in, boolean transientDeletions) {
        super(in);
        this.modCount = new AtomicLong(in.getVersion());
        this.transientDeletions = transientDeletions;
        this.deletedDocs = transientDeletions ? new CopyOnWriteArraySet() : null;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        if (this.transientDeletions) {
            this.deletedDocs.add(n);
            this.modCount.incrementAndGet();
        } else {
            super.doDelete(n);
            this.modCount.incrementAndGet();
        }
    }

    public boolean isDeleted(int n) {
        if (this.transientDeletions) {
            return this.deletedDocs.contains(n);
        }
        return super.isDeleted(n);
    }

    long getModificationCount() {
        return this.modCount.get();
    }
}

