/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldSelectors;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrIndexSearcher;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SortedLuceneQueryHits
extends AbstractQueryHits {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.SortedLuceneQueryHits");
    private static final int MAX_FETCH_SIZE = 32768;
    private static final int MIN_FETCH_SIZE = 32;
    private final IndexReader reader;
    private final JcrIndexSearcher searcher;
    private final Query query;
    private final Sort sort;
    private int hitIndex = -1;
    private final List<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
    private int size;
    private int numHits;

    public SortedLuceneQueryHits(IndexReader reader, JcrIndexSearcher searcher, Query query, Sort sort, long resultFetchHint) throws IOException {
        this.reader = reader;
        this.searcher = searcher;
        this.query = query;
        this.sort = sort;
        this.numHits = (int)Math.min(Math.max(resultFetchHint, 32L), 32768L);
        this.getHits();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public ScoreNode nextScoreNode() throws IOException {
        if (++this.hitIndex >= this.size) {
            return null;
        }
        if (this.hitIndex >= this.scoreDocs.size()) {
            this.numHits = Math.max(this.numHits, this.hitIndex * 2);
            this.getHits();
        }
        ScoreDoc doc = this.scoreDocs.get(this.hitIndex);
        String uuid = this.reader.document(doc.doc, FieldSelectors.UUID).get(FieldNames.UUID);
        return new ScoreNode(uuid, doc.score, doc.doc);
    }

    @Override
    public void skip(int n) throws IOException {
        this.hitIndex += n;
    }

    private void getHits() throws IOException {
        TopFieldCollector collector = TopFieldCollector.create((Sort)this.sort, (int)this.numHits, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        this.searcher.search(this.query, (Collector)collector);
        this.size = collector.getTotalHits();
        ScoreDoc[] docs = collector.topDocs().scoreDocs;
        for (int i = this.scoreDocs.size(); i < docs.length; ++i) {
            this.scoreDocs.add(docs[i]);
        }
        log.debug("getHits() {}/{}", (Object)this.scoreDocs.size(), (Object)this.numHits);
        this.numHits *= 2;
    }
}

