/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

public class OracleCleaningScipts
extends DBCleaningScripts {
    public OracleCleaningScipts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        super(dialect, rEntry);
        this.prepareRenamingApproachScripts();
    }

    public OracleCleaningScipts(String dialect, WorkspaceEntry wEntry) throws DBCleanException {
        super(dialect, wEntry);
        if (this.multiDb) {
            this.prepareRenamingApproachScripts();
        } else {
            this.prepareSimpleCleaningApproachScripts();
        }
    }

    @Override
    protected Collection<String> getConstraintsAddingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_PK_" + this.valueTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.itemTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.refTableSuffix + " PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)";
        scripts.add("ALTER TABLE " + this.refTableName + " ADD CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getConstraintsRemovingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_PK_" + this.valueTableSuffix;
        scripts.add("ALTER TABLE " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROPERTY";
        scripts.add("ALTER TABLE " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.itemTableSuffix;
        scripts.add("ALTER TABLE " + this.itemTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.refTableSuffix;
        scripts.add("ALTER TABLE " + this.refTableName + " DROP CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM");
        scripts.add("DROP INDEX JCR_IDX_" + this.itemTableSuffix + "_NAME");
        scripts.add("DROP INDEX JCR_IDX_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("DROP INDEX JCR_IDX_" + this.refTableSuffix + "_PROPERTY");
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesAddingScripts() throws DBCleanException {
        ArrayList<String> scripts = new ArrayList<String>();
        try {
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.itemTableSuffix + "_NAME ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.valueTableSuffix + "_PROPERTY ON " + this.valueTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.refTableSuffix + "_PROPERTY ON " + this.refTableName, this.multiDb, this.dialect, this.wsEntry));
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        catch (IOException e) {
            throw new DBCleanException(e);
        }
        return scripts;
    }

    @Override
    protected Collection<String> getTablesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP SEQUENCE " + this.valueTableName + "_SEQ");
        scripts.addAll(super.getTablesDroppingScripts());
        return scripts;
    }

    @Override
    protected Collection<String> getOldTablesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP SEQUENCE " + this.valueTableName + "_SEQ_OLD");
        scripts.addAll(super.getOldTablesDroppingScripts());
        return scripts;
    }

    @Override
    protected Collection<String> getTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.valueTableName + " RENAME TO " + this.valueTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD RENAME CONSTRAINT JCR_PK_" + this.valueTableSuffix + " TO JCR_PK_" + this.valueTableSuffix + "_OLD");
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD RENAME CONSTRAINT JCR_FK_" + this.valueTableSuffix + "_PROPERTY TO JCR_FK_" + this.valueTableSuffix + "_PROPERTY_OLD");
        scripts.add("ALTER INDEX JCR_PK_" + this.valueTableSuffix + " RENAME TO JCR_PK_" + this.valueTableSuffix + "_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.valueTableSuffix + "_PROPERTY RENAME TO JCR_IDX_" + this.valueTableSuffix + "_PROPERTY_OLD");
        scripts.add("RENAME " + this.valueTableName + "_SEQ TO " + this.valueTableName + "_SEQ_OLD");
        scripts.add("DROP TRIGGER BI_" + this.valueTableName);
        scripts.add("ALTER TABLE " + this.itemTableName + " RENAME TO " + this.itemTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD RENAME CONSTRAINT JCR_PK_" + this.itemTableSuffix + " TO JCR_PK_" + this.itemTableSuffix + "_OLD");
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD RENAME CONSTRAINT JCR_FK_" + this.itemTableSuffix + "_PARENT TO JCR_FK_" + this.itemTableSuffix + "_PARENT_OLD");
        scripts.add("ALTER INDEX JCR_PK_" + this.itemTableSuffix + " RENAME TO JCR_PK_" + this.itemTableSuffix + "_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM RENAME TO JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_NAME RENAME TO JCR_IDX_" + this.itemTableSuffix + "_NAME_OLD");
        scripts.add("ALTER TABLE " + this.refTableName + " RENAME TO " + this.refTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.refTableName + "_OLD RENAME CONSTRAINT JCR_PK_" + this.refTableSuffix + " TO JCR_PK_" + this.refTableSuffix + "_OLD");
        scripts.add("ALTER INDEX JCR_PK_" + this.refTableSuffix + " RENAME TO JCR_PK_" + this.refTableSuffix + "_OLD");
        scripts.add("ALTER INDEX JCR_IDX_" + this.refTableSuffix + "_PROPERTY RENAME TO JCR_IDX_" + this.refTableSuffix + "_PROPERTY_OLD");
        return scripts;
    }

    @Override
    protected Collection<String> getOldTablesRenamingScripts() throws DBCleanException {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD RENAME TO " + this.valueTableName + "");
        scripts.add("ALTER TABLE " + this.valueTableName + " RENAME CONSTRAINT JCR_PK_" + this.valueTableSuffix + "_OLD TO JCR_PK_" + this.valueTableSuffix);
        scripts.add("ALTER TABLE " + this.valueTableName + " RENAME CONSTRAINT JCR_FK_" + this.valueTableSuffix + "_PROPERTY_OLD TO JCR_FK_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("ALTER INDEX JCR_PK_" + this.valueTableSuffix + "_OLD RENAME TO JCR_PK_" + this.valueTableSuffix);
        scripts.add("ALTER INDEX JCR_IDX_" + this.valueTableSuffix + "_PROPERTY_OLD RENAME TO JCR_IDX_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("RENAME " + this.valueTableName + "_SEQ_OLD TO " + this.valueTableName + "_SEQ");
        try {
            scripts.add(DBInitializerHelper.getObjectScript("CREATE OR REPLACE trigger", this.multiDb, this.dialect, this.wsEntry));
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        catch (IOException e) {
            throw new DBCleanException(e);
        }
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD RENAME TO " + this.itemTableName + "");
        scripts.add("ALTER TABLE " + this.itemTableName + " RENAME CONSTRAINT JCR_PK_" + this.itemTableSuffix + "_OLD TO JCR_PK_" + this.itemTableSuffix);
        scripts.add("ALTER TABLE " + this.itemTableName + " RENAME CONSTRAINT JCR_FK_" + this.itemTableSuffix + "_PARENT_OLD TO JCR_FK_" + this.itemTableSuffix + "_PARENT");
        scripts.add("ALTER INDEX JCR_PK_" + this.itemTableSuffix + "_OLD RENAME TO JCR_PK_" + this.itemTableSuffix);
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_FK");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM");
        scripts.add("ALTER INDEX JCR_IDX_" + this.itemTableSuffix + "_NAME_OLD RENAME TO JCR_IDX_" + this.itemTableSuffix + "_NAME");
        scripts.add("ALTER TABLE " + this.refTableName + "_OLD RENAME TO " + this.refTableName + "");
        scripts.add("ALTER TABLE " + this.refTableName + " RENAME CONSTRAINT JCR_PK_" + this.refTableSuffix + "_OLD TO JCR_PK_" + this.refTableSuffix);
        scripts.add("ALTER INDEX JCR_PK_" + this.refTableSuffix + "_OLD RENAME TO JCR_PK_" + this.refTableSuffix);
        scripts.add("ALTER INDEX JCR_IDX_" + this.refTableSuffix + "_PROPERTY_OLD RENAME TO JCR_IDX_" + this.refTableSuffix + "_PROPERTY");
        return scripts;
    }
}

