/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemAutocreator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.RelatedDefinition;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsMatcher;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PropertyDefinitionComparator
extends AbstractDefinitionComparator<PropertyDefinitionData> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.PropertyDefinitionComparator");
    private final List<NodeData> affectedNodes;
    private final LocationFactory locationFactory;
    private final NodeTypeDataManager nodeTypeDataManager;
    private final ItemDataConsumer dataConsumer;
    private final ItemAutocreator itemAutocreator;

    public PropertyDefinitionComparator(NodeTypeDataManager nodeTypeDataManager, ItemDataConsumer dataConsumer, ItemAutocreator itemAutocreator, List<NodeData> affectedNodes, LocationFactory locationFactory) {
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.dataConsumer = dataConsumer;
        this.itemAutocreator = itemAutocreator;
        this.affectedNodes = affectedNodes;
        this.locationFactory = locationFactory;
    }

    public PlainChangesLog compare(NodeTypeData registeredNodeType, PropertyDefinitionData[] ancestorDefinition, PropertyDefinitionData[] recipientDefinition) throws RepositoryException {
        ArrayList sameDefinitionData = new ArrayList();
        ArrayList<RelatedDefinition<PropertyDefinitionData>> changedDefinitionData = new ArrayList<RelatedDefinition<PropertyDefinitionData>>();
        ArrayList<PropertyDefinitionData> newDefinitionData = new ArrayList<PropertyDefinitionData>();
        ArrayList<PropertyDefinitionData> removedDefinitionData = new ArrayList<PropertyDefinitionData>();
        this.init(ancestorDefinition, recipientDefinition, sameDefinitionData, changedDefinitionData, newDefinitionData, removedDefinitionData);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.validateRemoved(registeredNodeType, removedDefinitionData, recipientDefinition, this.affectedNodes);
        this.validateAdded(registeredNodeType, newDefinitionData, recipientDefinition, this.affectedNodes);
        this.validateChanged(registeredNodeType, changedDefinitionData, this.affectedNodes, recipientDefinition);
        this.doAdd(newDefinitionData, changesLog, this.affectedNodes, registeredNodeType);
        return changesLog;
    }

    private void checkIsMultiple(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition, List<NodeData> nodesData) throws RepositoryException, ConstraintViolationException {
        List<NodeData> checkIsMultipleNodes = Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName()) ? nodesData : this.getNodes(nodesData, new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (NodeData nodeData : checkIsMultipleNodes) {
            if (Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.dataConsumer.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition) || propertyData.getValues().size() <= 1) continue;
                    throw new ConstraintViolationException("Can't change property definition " + recipientDefinitionData.getName().getAsString() + " to isMultiple = false because property " + propertyData.getQPath().getAsString() + " contains more then one value");
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.dataConsumer.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0), ItemType.PROPERTY);
            if (propertyData.getValues().size() <= 1) continue;
            throw new ConstraintViolationException("Can't change property definition " + recipientDefinitionData.getName().getAsString() + " to isMultiple = false because property " + propertyData.getQPath().getAsString() + " contains more then one value");
        }
    }

    private void checkMandatory(NodeTypeData registeredNodeType, List<NodeData> nodesData, PropertyDefinitionData recipientDefinitionData) throws RepositoryException {
        if (Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName()) && recipientDefinitionData.isMandatory()) {
            throw new ConstraintViolationException("Invalid property definition " + (Object)((Object)recipientDefinitionData.getName()) + ". Residual definition can't be mandatory");
        }
        List<NodeData> mandatoryNodes = this.getNodes(nodesData, new InternalQName[0], new InternalQName[]{recipientDefinitionData.getName()});
        if (mandatoryNodes.size() > 0) {
            StringBuilder message = new StringBuilder("Can not change ").append(recipientDefinitionData.getName().getAsString()).append(" property definition from mandatory=false to mandatory = true , because ").append(" the following nodes ");
            for (NodeData nodeData : mandatoryNodes) {
                message.append(nodeData.getQPath().getAsString()).append(" ");
            }
            message.append("  doesn't have these properties ");
            throw new ConstraintViolationException(message.toString());
        }
    }

    private void checkRequiredType(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition, List<NodeData> nodesData) throws RepositoryException {
        List<NodeData> requiredTypeNodes = Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName()) ? nodesData : this.getNodes(nodesData, new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (NodeData nodeData : requiredTypeNodes) {
            if (Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.dataConsumer.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition) || recipientDefinitionData.getRequiredType() == 0 || propertyData.getType() == recipientDefinitionData.getRequiredType()) continue;
                    throw new ConstraintViolationException("Can not change  requiredType to " + ExtendedPropertyType.nameFromValue(recipientDefinitionData.getRequiredType()) + " in " + recipientDefinitionData.getName().getAsString() + "  because " + propertyData.getQPath().getAsString() + " have " + ExtendedPropertyType.nameFromValue(propertyData.getType()));
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.dataConsumer.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0), ItemType.PROPERTY);
            if (recipientDefinitionData.getRequiredType() == 0 || propertyData.getType() == recipientDefinitionData.getRequiredType()) continue;
            throw new ConstraintViolationException("Can not change  requiredType to " + ExtendedPropertyType.nameFromValue(recipientDefinitionData.getRequiredType()) + " in " + recipientDefinitionData.getName().getAsString() + "  because " + propertyData.getQPath().getAsString() + " have " + ExtendedPropertyType.nameFromValue(propertyData.getType()));
        }
    }

    private void checkValueConstraints(NodeTypeData registeredNodeType, PropertyDefinitionData recipientDefinitionData, PropertyDefinitionData[] allRecipientDefinition, List<NodeData> nodesData) throws RepositoryException, ConstraintViolationException {
        List<NodeData> checkValueConstraintsNodes = Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName()) ? nodesData : this.getNodes(nodesData, new InternalQName[]{recipientDefinitionData.getName()}, new InternalQName[0]);
        for (NodeData nodeData : checkValueConstraintsNodes) {
            if (Constants.JCR_ANY_NAME.equals((Object)recipientDefinitionData.getName())) {
                List<PropertyData> propertyDatas = this.dataConsumer.getChildPropertiesData(nodeData);
                for (PropertyData propertyData : propertyDatas) {
                    if (!this.isResidualMatch(propertyData.getQPath().getName(), allRecipientDefinition)) continue;
                    this.checkValueConstraints(recipientDefinitionData, propertyData);
                }
                continue;
            }
            PropertyData propertyData = (PropertyData)this.dataConsumer.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0), ItemType.PROPERTY);
            this.checkValueConstraints(recipientDefinitionData, propertyData);
        }
    }

    private void checkValueConstraints(PropertyDefinitionData def, PropertyData propertyData) throws RepositoryException {
        ValueConstraintsMatcher constraints = new ValueConstraintsMatcher(def.getValueConstraints(), this.locationFactory, this.dataConsumer, this.nodeTypeDataManager);
        for (ValueData value : propertyData.getValues()) {
            if (constraints.match(value, propertyData.getType())) continue;
            String strVal = null;
            try {
                strVal = propertyData.getType() != 2 ? ValueDataUtil.getString(value) : "PropertyType.BINARY";
            }
            catch (IllegalStateException e) {
                LOG.error((Object)("Error of value read: " + e.getMessage()), (Throwable)e);
            }
            throw new ConstraintViolationException("Value " + strVal + " for property " + propertyData.getQPath().getAsString() + " doesn't match new constraint ");
        }
    }

    private void doAdd(List<PropertyDefinitionData> toAddList, PlainChangesLog changesLog, List<NodeData> nodesData, NodeTypeData registeredNodeType) throws RepositoryException {
        for (NodeData nodeData : nodesData) {
            for (PropertyDefinitionData newPropertyDefinitionData : toAddList) {
                ItemData pdata;
                if (newPropertyDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME) || !newPropertyDefinitionData.isAutoCreated() || (pdata = this.dataConsumer.getItemData(nodeData, new QPathEntry(newPropertyDefinitionData.getName(), 0), ItemType.UNKNOWN)) != null && (pdata == null || !pdata.isNode())) continue;
                PlainChangesLog autoCreatedChanges = this.itemAutocreator.makeAutoCreatedProperties(nodeData, registeredNodeType.getName(), new PropertyDefinitionData[]{newPropertyDefinitionData}, this.dataConsumer, nodeData.getACL().getOwner());
                if (autoCreatedChanges.getSize() == 0) {
                    throw new ConstraintViolationException("Fail to add property by definition: " + newPropertyDefinitionData.getName().getAsString() + " Possible no default values defined.");
                }
                changesLog.addAll(autoCreatedChanges.getAllStates());
            }
        }
    }

    private List<NodeData> getNodes(List<NodeData> nodes, InternalQName[] includeProperties, InternalQName[] excludeProperties) throws RepositoryException {
        ArrayList<NodeData> result = new ArrayList<NodeData>();
        for (NodeData nodeData : nodes) {
            int i;
            List<PropertyData> childProperties = this.dataConsumer.listChildPropertiesData(nodeData);
            boolean toAdd = includeProperties.length == 0;
            block1: for (i = 0; i < includeProperties.length; ++i) {
                for (PropertyData propertyData : childProperties) {
                    if (!propertyData.getQPath().getName().equals((Object)includeProperties[i])) continue;
                    toAdd = true;
                    continue block1;
                }
            }
            if (!toAdd) continue;
            block3: for (i = 0; i < excludeProperties.length; ++i) {
                for (PropertyData propertyData : childProperties) {
                    if (!propertyData.getQPath().getName().equals((Object)excludeProperties[i])) continue;
                    toAdd = false;
                    continue block3;
                }
            }
            if (!toAdd) continue;
            result.add(nodeData);
        }
        return result;
    }

    private void validateAdded(NodeTypeData registeredNodeType, List<PropertyDefinitionData> newDefinitionData, PropertyDefinitionData[] allRecipientDefinition, List<NodeData> nodesData) throws RepositoryException {
        if (newDefinitionData.size() > 0) {
            for (PropertyDefinitionData propertyDefinitionData : newDefinitionData) {
                if (!propertyDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME)) continue;
                this.checkRequiredType(registeredNodeType, propertyDefinitionData, allRecipientDefinition, nodesData);
                this.checkValueConstraints(registeredNodeType, propertyDefinitionData, allRecipientDefinition, nodesData);
                this.checkIsMultiple(registeredNodeType, propertyDefinitionData, allRecipientDefinition, nodesData);
            }
        }
    }

    private void validateChanged(NodeTypeData registeredNodeType, List<RelatedDefinition<PropertyDefinitionData>> changedDefinitionData, List<NodeData> nodesData, PropertyDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (RelatedDefinition<PropertyDefinitionData> relatedDefinitions : changedDefinitionData) {
            PropertyDefinitionData ancestorDefinitionData = relatedDefinitions.getAncestorDefinition();
            PropertyDefinitionData recipientDefinitionData = relatedDefinitions.getRecepientDefinition();
            if (!ancestorDefinitionData.isMandatory() && recipientDefinitionData.isMandatory()) {
                this.checkMandatory(registeredNodeType, nodesData, recipientDefinitionData);
            }
            if (ancestorDefinitionData.getRequiredType() != recipientDefinitionData.getRequiredType() && recipientDefinitionData.getRequiredType() != 0) {
                this.checkRequiredType(registeredNodeType, recipientDefinitionData, allRecipientDefinition, nodesData);
            }
            if (!Arrays.deepEquals(ancestorDefinitionData.getValueConstraints(), recipientDefinitionData.getValueConstraints())) {
                this.checkValueConstraints(registeredNodeType, recipientDefinitionData, allRecipientDefinition, nodesData);
            }
            if (!ancestorDefinitionData.isMultiple() || recipientDefinitionData.isMultiple()) continue;
            this.checkIsMultiple(registeredNodeType, recipientDefinitionData, allRecipientDefinition, nodesData);
        }
    }

    private void validateRemoved(NodeTypeData registeredNodeType, List<PropertyDefinitionData> removedDefinitionData, PropertyDefinitionData[] recipientDefinition, List<NodeData> nodesData) throws RepositoryException {
        for (PropertyDefinitionData removePropertyDefinitionData : removedDefinitionData) {
            List<NodeData> nodes;
            if (removePropertyDefinitionData.getName().equals((Object)Constants.JCR_ANY_NAME)) {
                for (NodeData nodeData : nodesData) {
                    List<PropertyData> childs = this.dataConsumer.getChildPropertiesData(nodeData);
                    for (PropertyData propertyData : childs) {
                        if (this.isNonResidualMatch(propertyData.getQPath().getName(), recipientDefinition)) continue;
                        throw new ConstraintViolationException("Can't remove residual property definition for " + registeredNodeType.getName().getAsString() + " node type, because node " + nodeData.getQPath().getAsString() + " contains property " + propertyData.getQPath().getName().getAsString());
                    }
                }
                continue;
            }
            if (this.isResidualMatch(removePropertyDefinitionData.getName(), recipientDefinition) || (nodes = this.getNodes(nodesData, new InternalQName[]{removePropertyDefinitionData.getName()}, new InternalQName[0])).size() <= 0) continue;
            StringBuilder message = new StringBuilder("Can not remove ").append(removePropertyDefinitionData.getName().getAsString()).append(" PropertyDefinitionData, because the following nodes have these properties: ");
            for (NodeData nodeData : nodes) {
                message.append(nodeData.getQPath().getAsString()).append(" ");
            }
            throw new ConstraintViolationException(message.toString());
        }
    }
}

