/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.infinispan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.distribution.group.Group;

public abstract class CacheKey
implements Externalizable,
Comparable<CacheKey> {
    private String ownerId;
    private String id;
    private int hash;
    private String group;
    private String fullGroupName;

    public CacheKey() {
    }

    public CacheKey(String ownerId, String id) {
        this(ownerId, id, null);
    }

    public CacheKey(String ownerId, String id, String group) {
        this.ownerId = ownerId;
        this.id = id;
        this.hash = this.calculateHash();
        this.group = group;
    }

    public final String getOwnerId() {
        return this.ownerId;
    }

    public final int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + (this.ownerId == null ? "" : this.ownerId + "-") + this.id + "-" + this.group;
    }

    @Override
    public final int compareTo(CacheKey o) {
        int result = this.getClass().getName().compareTo(o.getClass().getName());
        if (result == 0 && this.ownerId != null) {
            result = this.ownerId.compareTo(o.ownerId);
        }
        return result == 0 ? this.id.compareTo(o.id) : result;
    }

    @Group
    public final String getGroup() {
        if (this.fullGroupName != null) {
            return this.fullGroupName;
        }
        StringBuilder sb = new StringBuilder();
        if (this.ownerId != null) {
            sb.append(this.ownerId).append('-');
        }
        this.fullGroupName = sb.append(this.group == null ? this.id : this.group).toString();
        return this.fullGroupName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf;
        if (this.ownerId == null) {
            out.writeInt(-1);
        } else {
            buf = this.ownerId.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        if (this.group == null) {
            out.writeInt(-1);
        } else {
            buf = this.group.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        buf = this.id.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        int length = in.readInt();
        if (length >= 0) {
            buf = new byte[length];
            in.readFully(buf);
            this.ownerId = new String(buf, "UTF-8");
        }
        if ((length = in.readInt()) >= 0) {
            buf = new byte[length];
            in.readFully(buf);
            this.group = new String(buf, "UTF-8");
        }
        buf = new byte[in.readInt()];
        in.readFully(buf);
        this.id = new String(buf, "UTF-8");
        this.hash = this.calculateHash();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)obj;
        if (cacheKey.hash == this.hash && cacheKey.id.equals(this.id)) {
            return this.ownerId != null ? this.ownerId.equals(cacheKey.ownerId) : true;
        }
        return false;
    }

    private int calculateHash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + this.getClass().getName().hashCode();
        return result;
    }
}

