/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AuditServiceImpl
implements AuditService,
Startable {
    private static final String ADMIN_INDENTITY = "adminIdentity";
    private static final String DEFAULT_INDENTITY = "defaultIdentity";
    private String adminIdentity;
    private String defaultIdentity;
    private InitParams initParams;
    private RegistryService registryService;
    private static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.AuditService");
    private List<String> adminIdentitys = null;
    private static final String SERVICE_NAME = "Audit";

    public AuditServiceImpl(InitParams initParams, RepositoryService repService) throws RepositoryConfigurationException {
        this(initParams, repService, null);
    }

    public AuditServiceImpl(InitParams initParams, RepositoryService repService, RegistryService registryService) throws RepositoryConfigurationException {
        this.initParams = initParams;
        this.registryService = registryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
                this.readParamsFromRegistryService(sessionProvider);
            }
        } else {
            this.readParamsFromFile();
        }
    }

    @Override
    public void addRecord(Item previousItem, Item currentItem, int eventType) throws RepositoryException {
        NodeData vancestor;
        int propertyType;
        this.checkIfAuditable(currentItem);
        AuditSession auditSession = new AuditSession(currentItem);
        SessionImpl session = (SessionImpl)currentItem.getSession();
        SessionDataManager dataManager = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + currentItem.getPath());
        }
        QPath path = QPath.makeChildPath((QPath)auditHistory.getQPath(), (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD);
        PropertyData pData = (PropertyData)dataManager.getItemData(path);
        String auditRecordName = String.valueOf(ValueDataUtil.getLong((ValueData)((ValueData)pData.getValues().get(0))) + 1L);
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(this.defaultIdentity, "set_property"));
        access.add(new AccessControlEntry(this.defaultIdentity, "read"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditRecordAccessControlList = new AccessControlList(session.getUserID(), access);
        TransientNodeData arNode = new TransientNodeData(QPath.makeChildPath((QPath)auditHistory.getQPath(), (InternalQName)new InternalQName(null, auditRecordName)), IdGenerator.generate(), -1, AuditService.EXO_AUDITRECORD, new InternalQName[0], Integer.parseInt(auditRecordName), auditHistory.getIdentifier(), exoAuditRecordAccessControlList);
        dataManager.update(new ItemState((ItemData)arNode, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        TransientPropertyData arPrType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false, (ValueData)new TransientValueData(arNode.getPrimaryTypeName()));
        TransientPropertyData arUser = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_USER, (int)1, (boolean)false, (ValueData)new TransientValueData(session.getUserID()));
        TransientPropertyData arCreated = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_CREATED, (int)5, (boolean)false, (ValueData)new TransientValueData(dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        TransientPropertyData arEventType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_EVENTTYPE, (int)3, (boolean)false, (ValueData)new TransientValueData((long)eventType));
        dataManager.update(new ItemState((ItemData)arPrType, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arUser, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arCreated, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        dataManager.update(new ItemState((ItemData)arEventType, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        if (!currentItem.isNode() && (propertyType = ((Property)currentItem).getType()) != 2) {
            TransientPropertyData arNewValue = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_NEWVALUE, (int)propertyType, (boolean)((PropertyImpl)currentItem).isMultiValued(), (List)((PropertyData)((PropertyImpl)currentItem).getData()).getValues());
            dataManager.update(new ItemState((ItemData)arNewValue, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
            if (eventType == 16) {
                TransientPropertyData arOldValue = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_OLDVALUE, (int)propertyType, (boolean)((PropertyImpl)previousItem).isMultiValued(), (List)((PropertyData)((PropertyImpl)previousItem).getData()).getValues());
                dataManager.update(new ItemState((ItemData)arOldValue, 1, true, ((ItemImpl)previousItem).getInternalPath()), true);
            }
        }
        if (currentItem.isNode()) {
            vancestor = ((NodeImpl)currentItem).getVersionableAncestor();
        } else {
            vancestor = ((NodeImpl)((Property)currentItem).getParent()).getVersionableAncestor();
            TransientPropertyData propertyNameData = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_PROPERTYNAME, (int)1, (boolean)false, (ValueData)new TransientValueData(((ItemImpl)currentItem).getInternalName()));
            dataManager.update(new ItemState((ItemData)propertyNameData, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        }
        if (vancestor != null) {
            StringBuilder versionName = new StringBuilder();
            PropertyData bvProp = (PropertyData)dataManager.getItemData(vancestor, new QPathEntry(Constants.JCR_BASEVERSION, 1), ItemType.PROPERTY);
            String versionUUID = ValueDataUtil.getString((ValueData)((ValueData)bvProp.getValues().get(0)));
            Version version = (Version)dataManager.getItemByIdentifier(versionUUID, false);
            versionName = new StringBuilder(version.getName());
            if (!dataManager.isNew(version.getParent().getUUID())) {
                VersionHistory versionHistory = (VersionHistory)dataManager.getItemByIdentifier(version.getParent().getUUID(), false);
                String[] labels = versionHistory.getVersionLabels(version);
                for (int i = 0; i < labels.length; ++i) {
                    String vl = labels[i];
                    if (i == 0) {
                        versionName.append(" ");
                    }
                    versionName.append("'").append(vl).append("' ");
                }
            }
            TransientPropertyData auditVersion = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_AUDITVERSION, (int)1, (boolean)false, (ValueData)new TransientValueData(versionUUID));
            TransientPropertyData auditVersionName = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_AUDITVERSIONNAME, (int)1, (boolean)false, (ValueData)new TransientValueData(versionName.toString()));
            dataManager.update(new ItemState((ItemData)auditVersion, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
            dataManager.update(new ItemState((ItemData)auditVersionName, 1, true, ((ItemImpl)currentItem).getInternalPath()), true);
        }
        PropertyData pLastRecord = (PropertyData)auditSession.getDataManager().getItemData(QPath.makeChildPath((QPath)auditHistory.getQPath(), (InternalQName)EXO_AUDITHISTORY_LASTRECORD));
        pLastRecord = new TransientPropertyData(pLastRecord.getQPath(), pLastRecord.getIdentifier(), pLastRecord.getPersistedVersion(), pLastRecord.getType(), pLastRecord.getParentIdentifier(), pLastRecord.isMultiValued(), (ValueData)new TransientValueData(String.valueOf(auditRecordName)));
        dataManager.update(new ItemState((ItemData)pLastRecord, 2, true, ((ItemImpl)currentItem).getInternalPath()), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add audit record:  Item path=" + ((ItemImpl)currentItem).getLocation().getInternalPath().getAsString() + " User=" + session.getUserID() + " EventType=" + eventType));
        }
    }

    @Override
    public void createHistory(Node node) throws RepositoryException {
        this.checkIfAuditable((Item)node);
        AuditSession auditSession = new AuditSession((Item)node);
        NodeData storage = auditSession.getAuditStorage();
        SessionImpl session = (SessionImpl)node.getSession();
        InternalQName aiName = new InternalQName(null, ((ItemImpl)node).getData().getIdentifier());
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(this.defaultIdentity, "add_node"));
        access.add(new AccessControlEntry(this.defaultIdentity, "read"));
        access.add(new AccessControlEntry(this.defaultIdentity, "set_property"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditHistoryAccessControlList = new AccessControlList(session.getUserID(), access);
        TransientNodeData ahNode = new TransientNodeData(QPath.makeChildPath((QPath)storage.getQPath(), (InternalQName)aiName), IdGenerator.generate(), -1, AuditService.EXO_AUDITHISTORY, new InternalQName[]{Constants.MIX_REFERENCEABLE, Constants.EXO_PRIVILEGEABLE}, 0, storage.getIdentifier(), exoAuditHistoryAccessControlList);
        TransientPropertyData aPrType = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false, (ValueData)new TransientValueData(ahNode.getPrimaryTypeName()));
        TransientPropertyData ahUuid = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false, (ValueData)new TransientValueData(ahNode.getIdentifier()));
        ArrayList<TransientValueData> mixValues = new ArrayList<TransientValueData>();
        mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
        mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
        TransientPropertyData ahMixinTypes = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)true, mixValues);
        ArrayList<TransientValueData> permsValues = new ArrayList<TransientValueData>();
        for (int i = 0; i < ahNode.getACL().getPermissionEntries().size(); ++i) {
            AccessControlEntry entry = (AccessControlEntry)ahNode.getACL().getPermissionEntries().get(i);
            permsValues.add(new TransientValueData(entry));
        }
        TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.EXO_PERMISSIONS, (int)100, (boolean)true, permsValues);
        TransientPropertyData ahTargetNode = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_TARGETNODE, (int)9, (boolean)false, (ValueData)new TransientValueData(((ItemImpl)node).getData().getIdentifier()));
        TransientPropertyData ahLastRecord = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD, (int)1, (boolean)false, (ValueData)new TransientValueData("0"));
        TransientPropertyData pAuditHistory = TransientPropertyData.createPropertyData((NodeData)((NodeData)((ItemImpl)node).getData()), (InternalQName)AuditService.EXO_AUDITHISTORY, (int)1, (boolean)false, (ValueData)new TransientValueData(new Identifier(ahNode.getIdentifier())));
        session.getTransientNodesManager().update(new ItemState((ItemData)ahNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)aPrType, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahUuid, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahMixinTypes, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)exoAuditPerms, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahTargetNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahLastRecord, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)pAuditHistory, 1, true, ((ItemImpl)node).getInternalPath()), true);
    }

    @Override
    public AuditHistory getHistory(Node node) throws RepositoryException, UnsupportedOperationException {
        AuditSession auditSession = new AuditSession((Item)node);
        SessionDataManager dm = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory != null) {
            ArrayList<AuditRecord> auditRecords = new ArrayList<AuditRecord>();
            ValueFactoryImpl vf = (ValueFactoryImpl)node.getSession().getValueFactory();
            List auditRecordsNodeData = dm.getChildNodesData(auditHistory);
            for (NodeData nodeData : auditRecordsNodeData) {
                List auditRecordNodeData = dm.getChildPropertiesData(nodeData);
                String user = null;
                InternalQName propertyName = null;
                Value[] oldValue = null;
                Value[] newValue = null;
                int eventType = -1;
                Calendar date = null;
                String version = null;
                String versionName = null;
                try {
                    for (PropertyData propertyData : auditRecordNodeData) {
                        int i;
                        ValueData value = (ValueData)propertyData.getValues().get(0);
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_USER)) {
                            user = ValueDataUtil.getString((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_EVENTTYPE)) {
                            eventType = ValueDataUtil.getLong((ValueData)value).intValue();
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_CREATED)) {
                            date = ValueDataUtil.getDate((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_PROPERTYNAME)) {
                            propertyName = InternalQName.parse((String)ValueDataUtil.getString((ValueData)value));
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_AUDITVERSION)) {
                            version = ValueDataUtil.getString((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_AUDITVERSIONNAME)) {
                            versionName = ValueDataUtil.getString((ValueData)value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_OLDVALUE)) {
                            oldValue = new Value[propertyData.getValues().size()];
                            for (i = 0; i < propertyData.getValues().size(); ++i) {
                                oldValue[i] = vf.loadValue((ValueData)propertyData.getValues().get(i), propertyData.getType());
                            }
                            continue;
                        }
                        if (!propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_NEWVALUE)) continue;
                        newValue = new Value[propertyData.getValues().size()];
                        for (i = 0; i < propertyData.getValues().size(); ++i) {
                            newValue[i] = vf.loadValue((ValueData)propertyData.getValues().get(i), propertyData.getType());
                        }
                    }
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (IllegalNameException e) {
                    throw new RepositoryException((Throwable)e);
                }
                auditRecords.add(new AuditRecord(user, eventType, date, propertyName, oldValue, newValue, version, versionName));
            }
            return new AuditHistory(node, auditRecords);
        }
        throw new PathNotFoundException("Audit history not found for " + node.getPath());
    }

    @Override
    public boolean hasHistory(Node node) {
        NodeData data;
        try {
            AuditSession auditSession = new AuditSession((Item)node);
            data = auditSession.getAuditHistoryNodeData();
        }
        catch (RepositoryException e) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Audit history for " + node.getPath() + " not accessible due to error " + e), (Throwable)e);
                }
            }
            catch (RepositoryException e1) {
                LOG.error((Object)("Can't read node path for " + node), (Throwable)e1);
            }
            return false;
        }
        return data != null;
    }

    @Override
    public void removeHistory(Node node) throws RepositoryException {
        AuditSession auditSession = new AuditSession((Item)node);
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + node.getPath());
        }
        SessionImpl session = (SessionImpl)node.getSession();
        session.getTransientNodesManager().delete((ItemData)auditHistory);
    }

    private void checkIfAuditable(Item item) throws RepositoryException, UnsupportedOperationException {
        NodeImpl node;
        NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        if (!node.isNodeType("exo:auditable")) {
            throw new ConstraintViolationException("exo:auditable node expected at: " + node.getPath());
        }
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement(ADMIN_INDENTITY);
        this.setAttributeSmart(element, "value", this.adminIdentity);
        root.appendChild(element);
        element = doc.createElement(DEFAULT_INDENTITY);
        this.setAttributeSmart(element, "value", this.defaultIdentity);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException, RepositoryConfigurationException {
        String entryPath = "exo:services/Audit/adminIdentity";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.adminIdentity = this.getAttributeSmart(element, "value");
        LOG.info((Object)"Admin identity is read from RegistryService");
        try {
            entryPath = "exo:services/Audit/defaultIdentity";
            registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
            doc = registryEntry.getDocument();
            element = doc.getDocumentElement();
            this.defaultIdentity = this.getAttributeSmart(element, "value");
            LOG.info((Object)"Default identity is read from RegistryService");
        }
        catch (PathNotFoundException e) {
            LOG.debug((Object)"The admin identity exists but not the default identity, so we will recreate it");
            this.registryService.removeEntry(sessionProvider, "exo:services/Audit");
            throw e;
        }
        this.checkParams();
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        if (this.initParams != null) {
            ValueParam defaultIdentityParam;
            ValueParam valParam = this.initParams.getValueParam(ADMIN_INDENTITY);
            if (valParam != null) {
                this.adminIdentity = valParam.getValue();
                LOG.info((Object)"Admin identity is read from configuration file");
            }
            if ((defaultIdentityParam = this.initParams.getValueParam(DEFAULT_INDENTITY)) != null) {
                this.defaultIdentity = defaultIdentityParam.getValue();
                LOG.info((Object)"Default identity is read from configuration file");
            }
        }
        this.checkParams();
    }

    private void checkParams() {
        if (this.adminIdentity == null) {
            throw new IllegalArgumentException("Admin identity is not configured");
        }
        StringTokenizer listTokenizer = new StringTokenizer(this.adminIdentity, ";");
        if (listTokenizer.countTokens() < 1) {
            throw new IllegalArgumentException("AccessControlList " + this.adminIdentity + " is empty or have a bad format");
        }
        this.adminIdentitys = new ArrayList<String>(listTokenizer.countTokens());
        while (listTokenizer.hasMoreTokens()) {
            this.adminIdentitys.add(listTokenizer.nextToken());
        }
        if (this.defaultIdentity == null) {
            this.defaultIdentity = IdentityConstants.ANY;
        }
    }

    public void stop() {
    }

    private class AuditSession {
        private final SessionImpl session;
        private final SessionDataManager dataManager;
        private ExtendedNode node;

        private AuditSession(Item item) throws RepositoryException {
            this.session = (SessionImpl)item.getSession();
            this.node = item.isNode() ? (ExtendedNode)item : (ExtendedNode)item.getParent();
            if (!this.node.isNodeType(AuditService.EXO_AUDITABLE)) {
                throw new RepositoryException("Node is not exo:auditable " + this.node.getPath());
            }
            this.dataManager = this.session.getTransientNodesManager();
        }

        private NodeData getAuditHistoryNodeData() throws RepositoryException {
            PropertyData pData = (PropertyData)this.dataManager.getItemData((NodeData)((NodeImpl)this.node).getData(), new QPathEntry(AuditService.EXO_AUDITHISTORY, 0), ItemType.PROPERTY);
            if (pData != null) {
                try {
                    String ahUuid = ValueDataUtil.getString((ValueData)((ValueData)pData.getValues().get(0)));
                    return (NodeData)this.dataManager.getItemData(ahUuid);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", (Throwable)e);
                }
            }
            return null;
        }

        private NodeData getAuditStorage() throws RepositoryException {
            ItemData storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            if (storage == null) {
                SessionChangesLog changesLog = new SessionChangesLog((ExtendedSession)this.session);
                ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
                access.add(new AccessControlEntry(AuditServiceImpl.this.defaultIdentity, "add_node"));
                access.add(new AccessControlEntry(AuditServiceImpl.this.defaultIdentity, "remove"));
                for (String identity : AuditServiceImpl.this.adminIdentitys) {
                    access.add(new AccessControlEntry(identity, "read"));
                }
                AccessControlList exoAuditAccessControlList = new AccessControlList(IdentityConstants.SYSTEM, access);
                InternalQName[] mixins = new InternalQName[]{Constants.EXO_PRIVILEGEABLE, Constants.MIX_REFERENCEABLE};
                TransientNodeData exoAuditNode = new TransientNodeData(QPath.makeChildPath((QPath)Constants.ROOT_PATH, (InternalQName)AuditService.EXO_AUDIT), "00exo0jcr0audit0storage0id000000", -1, AuditService.EXO_AUDITSTORAGE, mixins, 0, "00exo0jcr0root0uuid0000000000000", exoAuditAccessControlList);
                TransientPropertyData exoAuditPrType = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false, (ValueData)new TransientValueData(exoAuditNode.getPrimaryTypeName()));
                TransientPropertyData exoAuditUuid = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false, (ValueData)new TransientValueData(exoAuditNode.getIdentifier()));
                ArrayList<TransientValueData> mixValues = new ArrayList<TransientValueData>();
                mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
                mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
                TransientPropertyData exoAuditMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)true, mixValues);
                ArrayList<TransientValueData> permsValues = new ArrayList<TransientValueData>();
                for (int i = 0; i < exoAuditNode.getACL().getPermissionEntries().size(); ++i) {
                    AccessControlEntry entry = (AccessControlEntry)exoAuditNode.getACL().getPermissionEntries().get(i);
                    permsValues.add(new TransientValueData(entry));
                }
                TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.EXO_PERMISSIONS, (int)100, (boolean)true, permsValues);
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditNode));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditPrType));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditUuid));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditMixinTypes));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditPerms));
                this.session.getTransientNodesManager().getTransactManager().save((ItemStateChangesLog)changesLog);
                storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            }
            if (!storage.isNode()) {
                throw new RepositoryException("Item with uuid 00exo0jcr0audit0storage0id000000 should be node  ");
            }
            return (NodeData)storage;
        }

        private SessionDataManager getDataManager() {
            return this.dataManager;
        }
    }
}

