/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web.fckeditor;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.frameworks.jcr.web.fckeditor.FCKeditor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JCRContentFCKeditor
extends FCKeditor {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.framework.command.JCRContentFCKeditor");
    private final String filePath;
    private final SessionProviderService sessionProviderService;
    private final ManageableRepository repo;

    public JCRContentFCKeditor(HttpServletRequest req, String parInstanceName, String workspaceName, String filePath, String newNodeType) throws RepositoryException {
        super(req, parInstanceName);
        Node file;
        this.filePath = filePath;
        ExoContainer container = (ExoContainer)req.getSession().getServletContext().getAttribute("org.exoplatform.frameworks.web.eXoContainer");
        if (container == null) {
            container = PortalContainer.getCurrentInstance((ServletContext)req.getSession().getServletContext());
        }
        this.sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        this.repo = repositoryService.getCurrentRepository();
        Session session = this.sessionProviderService.getSessionProvider(null).getSession(this.repo.getConfiguration().getDefaultWorkspaceName(), this.repo);
        try {
            file = (Node)session.getItem(filePath);
        }
        catch (PathNotFoundException e1) {
            file = session.getRootNode().addNode(filePath.substring(1), newNodeType);
        }
        if (!file.isNodeType("nt:file")) {
            throw new RepositoryException("The Node should be nt:file type");
        }
        try {
            Property content = (Property)session.getItem(filePath + "/jcr:content/jcr:data");
            this.setValue(content.getString());
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Repository error " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveValue(String value) throws RepositoryException {
        Session session = this.sessionProviderService.getSessionProvider(null).getSession(this.repo.getConfiguration().getDefaultWorkspaceName(), this.repo);
        try {
            Node file = (Node)session.getItem(this.filePath);
            file.getNode("jcr:content").setProperty("jcr:data", value);
            this.setValue(value);
            file.getSession().save();
        }
        finally {
            session.logout();
        }
    }
}

