/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCConfigurationPersister
implements ConfigurationPersister {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCConfigurationPersister");
    public static final String PARAM_SOURCE_NAME = "source-name";
    public static final String PARAM_DIALECT = "dialect";
    protected static final String CONFIGNAME = "REPOSITORY-SERVICE-WORKING-CONFIG";
    protected static final String C_DATA = "CONFIGDATA";
    protected String configTableName = "JCR_CONFIG";
    protected String sourceName;
    protected String initSQL;

    @Override
    public void init(PropertiesParam params) throws RepositoryConfigurationException {
        String dialect;
        String sourceNameParam = params.getProperty(PARAM_SOURCE_NAME);
        if (sourceNameParam == null && (sourceNameParam = params.getProperty("sourceName")) == null) {
            throw new RepositoryConfigurationException("Repository service configuration. Source name (source-name) is expected");
        }
        this.sourceName = sourceNameParam;
        String dialectParam = params.getProperty(PARAM_DIALECT);
        String string = dialect = dialectParam == null ? "AUTO" : dialectParam.toUpperCase();
        if (dialect.startsWith("AUTO")) {
            Connection conn = null;
            try {
                conn = this.openConnection();
                dialect = DialectDetecter.detect((DatabaseMetaData)conn.getMetaData());
            }
            catch (NamingException e) {
                throw new RepositoryConfigurationException(e);
            }
            catch (SQLException e) {
                throw new RepositoryConfigurationException(e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        throw new RepositoryConfigurationException(e);
                    }
                }
            }
        }
        String binType = "BLOB";
        if (dialect.startsWith("GENERIC") || dialect.startsWith("HSQLDB")) {
            binType = "VARBINARY(1000000)";
        } else if (dialect.startsWith("PGSQL")) {
            this.configTableName = this.configTableName.toUpperCase().toLowerCase();
            binType = "BYTEA";
        } else if (dialect.startsWith("MSSQL")) {
            binType = "VARBINARY(max)";
        } else if (dialect.startsWith("SYBASE")) {
            binType = "IMAGE";
        } else if (dialect.startsWith("INGRES")) {
            this.configTableName = this.configTableName.toUpperCase().toLowerCase();
            binType = "LONG BYTE";
        } else if (dialect.startsWith("MYSQL")) {
            binType = "LONGBLOB";
        }
        this.initSQL = "CREATE TABLE " + this.configTableName + " (NAME VARCHAR(64) NOT NULL, CONFIG " + binType + " NOT NULL, CONSTRAINT JCR_CONFIG_PK PRIMARY KEY(NAME))";
    }

    protected void checkInitialized() throws RepositoryConfigurationException {
        if (this.sourceName == null) {
            throw new RepositoryConfigurationException("Repository service configuration persister isn not initialized. Call init() before.");
        }
    }

    protected Connection openConnection() throws NamingException, SQLException {
        final DataSource ds = (DataSource)new InitialContext().lookup(this.sourceName);
        return (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return ds.getConnection();
            }
        });
    }

    protected boolean isDbInitialized(final Connection con) {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JDBCUtils.tableExists((String)JDBCConfigurationPersister.this.configTableName, (Connection)con);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasConfig() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            Connection con = this.openConnection();
            ResultSet res = null;
            Statement ps = null;
            try {
                if (this.isDbInitialized(con)) {
                    ps = con.prepareStatement("SELECT COUNT(*) FROM " + this.configTableName + " WHERE NAME=?");
                    ps.setString(1, CONFIGNAME);
                    res = ps.executeQuery();
                    if (res.next()) {
                        boolean bl2 = res.getInt(1) > 0;
                        return bl2;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (res != null) {
                    try {
                        res.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                con.close();
            }
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream read() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            Connection con = this.openConnection();
            ResultSet res = null;
            Statement ps = null;
            try {
                if (!this.isDbInitialized(con)) throw new ConfigurationNotInitializedException("Configuration table not is found in database. Source name " + this.sourceName);
                ps = con.prepareStatement("SELECT * FROM " + this.configTableName + " WHERE NAME=?");
                ps.setString(1, CONFIGNAME);
                res = ps.executeQuery();
                if (!res.next()) throw new ConfigurationNotFoundException("No configuration data is found in database. Source name " + this.sourceName);
                ConfigDataHolder config = new ConfigDataHolder(res.getBinaryStream("config"));
                InputStream inputStream = config.getStream();
                return inputStream;
            }
            finally {
                if (res != null) {
                    try {
                        res.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                con.close();
            }
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(InputStream confData) throws RepositoryConfigurationException {
        this.checkInitialized();
        Object sql = null;
        try {
            Connection con = this.openConnection();
            Statement ps = null;
            try {
                if (!this.isDbInitialized(con)) {
                    con.setAutoCommit(true);
                    Statement st = con.createStatement();
                    sql = this.initSQL;
                    st.executeUpdate((String)sql);
                    st.close();
                    con.close();
                    con = this.openConnection();
                }
                con.setAutoCommit(false);
                if (this.isDbInitialized(con)) {
                    ConfigDataHolder config = new ConfigDataHolder(confData);
                    if (this.hasConfig()) {
                        sql = "UPDATE " + this.configTableName + " SET CONFIG=? WHERE NAME=?";
                        ps = con.prepareStatement((String)sql);
                        ps.setBinaryStream(1, config.getStream(), config.getLength());
                        ps.setString(2, CONFIGNAME);
                    } else {
                        sql = "INSERT INTO " + this.configTableName + " (NAME, CONFIG) VALUES (?,?)";
                        ps = con.prepareStatement((String)sql);
                        ps.setString(1, CONFIGNAME);
                        ps.setBinaryStream(2, config.getStream(), config.getLength());
                    }
                    if (ps.executeUpdate() <= 0) {
                        LOG.warn((Object)("Repository service configuration doesn't stored ok. No rows was affected in JDBC operation. Datasource " + this.sourceName + ". SQL: " + (String)sql));
                    }
                } else {
                    throw new ConfigurationNotInitializedException("Configuration table can not be created in database. Source name " + this.sourceName + ". SQL: " + (String)sql);
                }
                con.commit();
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
                con.close();
            }
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e + ". SQL: " + sql, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    protected class ConfigDataHolder {
        private final byte[] config;

        ConfigDataHolder(InputStream source) throws IOException {
            ByteArrayOutputStream configOut = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = source.read(b)) > 0) {
                configOut.write(b, 0, read);
            }
            this.config = configOut.toByteArray();
        }

        InputStream getStream() {
            return new ByteArrayInputStream(this.config);
        }

        int getLength() {
            return this.config.length;
        }
    }

    public class ConfigurationNotInitializedException
    extends RepositoryConfigurationException {
        ConfigurationNotInitializedException(String m) {
            super(m);
        }
    }

    public class ConfigurationNotFoundException
    extends RepositoryConfigurationException {
        ConfigurationNotFoundException(String m) {
            super(m);
        }
    }
}

