/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.hits;

import java.util.Arrays;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.Hits;

public class ArrayHits
implements Hits {
    private static final int INITIAL_SIZE = 100;
    private int[] hits;
    private int index;
    private boolean initialized;

    public ArrayHits() {
        this(100);
    }

    public ArrayHits(int initialSize) {
        this.hits = new int[initialSize];
        this.index = 0;
        this.initialized = false;
    }

    private void initialize() {
        if (!this.initialized) {
            Arrays.sort(this.hits);
            this.index = this.hits.length - this.index;
            this.initialized = true;
        }
    }

    @Override
    public void set(int doc) {
        if (this.initialized) {
            throw new IllegalStateException("You must not call set() after next() or skipTo()");
        }
        if (this.index >= this.hits.length) {
            int[] resizedHits = new int[this.hits.length * 2];
            System.arraycopy(this.hits, 0, resizedHits, 0, this.hits.length);
            this.hits = resizedHits;
        }
        this.hits[this.index++] = doc;
    }

    @Override
    public int next() {
        this.initialize();
        if (this.index >= this.hits.length) {
            return -1;
        }
        return this.hits[this.index++];
    }

    @Override
    public int skipTo(int target) {
        this.initialize();
        for (int i = this.index; i < this.hits.length; ++i) {
            int nextDocValue = this.hits[i];
            if (nextDocValue < target) continue;
            this.index = i;
            return this.next();
        }
        return -1;
    }
}

