/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.access.DynamicIdentity;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.SessionReference;
import org.exoplatform.services.jcr.impl.core.TrackedSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class SessionFactory {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionFactory");
    private final ExoContainer container;
    private final String workspaceName;

    public SessionFactory(WorkspaceEntry config, ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        this.workspaceName = config.getName();
        boolean tracking = "true".equalsIgnoreCase(PrivilegedSystemHelper.getProperty((String)"exo.jcr.session.tracking.active", (String)"false"));
        if (tracking) {
            long maxAgeMillis;
            block8: {
                maxAgeMillis = 0L;
                String maxagevalue = PrivilegedSystemHelper.getProperty((String)"exo.jcr.session.tracking.maxage");
                if (maxagevalue != null) {
                    try {
                        maxAgeMillis = Long.parseLong(maxagevalue) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isTraceEnabled()) break block8;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
            if (maxAgeMillis <= 0L) {
                maxAgeMillis = 120000L;
            }
            try {
                SessionReference.start(maxAgeMillis);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (config.getContainer().getParameterInteger("lazy-node-iterator-page-size", 100) < 20) {
            config.getContainer().putParameterValue("lazy-node-iterator-page-size", Integer.toString(20));
            LOG.warn((Object)"Value for \"lazy-node-iterator-page-size\" is too small. Using allowed minimum page size : 20.");
        }
    }

    SessionImpl createSession(ConversationState user) throws RepositoryException, LoginException {
        SecurityManager security;
        if (IdentityConstants.SYSTEM.equals(user.getIdentity().getUserId())) {
            SecurityManager security2 = System.getSecurityManager();
            if (security2 != null) {
                security2.checkPermission(JCRRuntimePermissions.CREATE_SYSTEM_SESSION_PERMISSION);
            }
        } else if (DynamicIdentity.DYNAMIC.equals(user.getIdentity().getUserId()) && (security = System.getSecurityManager()) != null) {
            security.checkPermission(JCRRuntimePermissions.CREATE_DYNAMIC_SESSION_PERMISSION);
        }
        if (SessionReference.isStarted()) {
            return new TrackedSession(this.workspaceName, user, this.container);
        }
        return new SessionImpl(this.workspaceName, user, this.container);
    }
}

