/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;

public class DefaultQueryNodeFactory
implements QueryNodeFactory {
    public static final List<InternalQName> VALID_SYSTEM_INDEX_NODE_TYPE_NAMES = Collections.unmodifiableList(Arrays.asList(Constants.NT_CHILDNODEDEFINITION, Constants.NT_FROZENNODE, Constants.NT_NODETYPE, Constants.NT_PROPERTYDEFINITION, Constants.NT_VERSION, Constants.NT_VERSIONEDCHILD, Constants.NT_VERSIONHISTORY, Constants.NT_VERSIONLABELS, Constants.JCR_NODETYPES, Constants.JCR_SYSTEM, Constants.JCR_VERSIONSTORAGE, Constants.NT_BASE, Constants.MIX_REFERENCEABLE));
    private final List<InternalQName> validJcrSystemNodeTypeNames;

    public DefaultQueryNodeFactory() {
        this(VALID_SYSTEM_INDEX_NODE_TYPE_NAMES);
    }

    public DefaultQueryNodeFactory(List<InternalQName> validJcrSystemNodeTypeNames) {
        this.validJcrSystemNodeTypeNames = validJcrSystemNodeTypeNames;
    }

    @Override
    public NodeTypeQueryNode createNodeTypeQueryNode(QueryNode parent, InternalQName nodeType) {
        return new NodeTypeQueryNode(parent, nodeType);
    }

    @Override
    public AndQueryNode createAndQueryNode(QueryNode parent) {
        return new AndQueryNode(parent);
    }

    @Override
    public LocationStepQueryNode createLocationStepQueryNode(QueryNode parent) {
        return new LocationStepQueryNode(parent);
    }

    @Override
    public DerefQueryNode createDerefQueryNode(QueryNode parent, InternalQName nameTest, boolean descendants) {
        return new DerefQueryNode(parent, nameTest, descendants);
    }

    @Override
    public NotQueryNode createNotQueryNode(QueryNode parent) {
        return new NotQueryNode(parent);
    }

    @Override
    public OrQueryNode createOrQueryNode(QueryNode parent) {
        return new OrQueryNode(parent);
    }

    @Override
    public RelationQueryNode createRelationQueryNode(QueryNode parent, int operation) {
        return new RelationQueryNode(parent, operation);
    }

    @Override
    public PathQueryNode createPathQueryNode(QueryNode parent) {
        return new PathQueryNode(parent, this.validJcrSystemNodeTypeNames);
    }

    @Override
    public OrderQueryNode createOrderQueryNode(QueryNode parent) {
        return new OrderQueryNode(parent);
    }

    @Override
    public PropertyFunctionQueryNode createPropertyFunctionQueryNode(QueryNode parent, String functionName) {
        return new PropertyFunctionQueryNode(parent, functionName);
    }

    @Override
    public QueryRootNode createQueryRootNode() {
        return new QueryRootNode();
    }

    @Override
    public TextsearchQueryNode createTextsearchQueryNode(QueryNode parent, String query) {
        return new TextsearchQueryNode(parent, query);
    }
}

