/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;

public class JCRPathExt
extends JCRPath {
    private static JCRPath.PathElement[] EMPTY_PATH = new JCRPath.PathElement[0];
    private static final JCRPath.PathElement THIS_ELEMENT = new JCRPath.PathElement("", ".", "", -1);
    private static final JCRPath.PathElement MOVE_UP_ELEMENT = new JCRPath.PathElement("", "..", "", -1);
    protected final JCRPath.PathElement[] names;
    protected final int size;
    protected String cachedToString;
    protected String cachedToStringShowIndex;
    protected QPath cachedInternalQPath;
    public static final JCRPathExt ROOT = new JCRPathExt();

    private JCRPathExt() {
        this(EMPTY_PATH);
    }

    JCRPathExt(NamespaceAccessor namespaces, QPathEntry[] path) throws RepositoryException {
        JCRPath.PathElement[] names = new JCRPath.PathElement[path.length];
        int size = 0;
        for (QPathEntry entry : path) {
            String prefix = namespaces.getNamespacePrefixByURI(entry.getNamespace());
            JCRPath.PathElement element = JCRPathExt.element(entry.getNamespace(), entry.getName(), prefix, entry.getIndex());
            size = JCRPathExt.addEntry(names, size, element);
        }
        this.names = names;
        this.size = size;
    }

    JCRPathExt(JCRPathExt that, JCRPath.PathElement[] addedEntries, int addedSize) {
        int i;
        JCRPath.PathElement[] names = new JCRPath.PathElement[that.size + addedSize];
        int size = 0;
        for (i = 0; i < that.size; ++i) {
            size = JCRPathExt.addEntry(names, size, that.names[i]);
        }
        for (i = 0; i < addedSize; ++i) {
            size = JCRPathExt.addEntry(names, size, addedEntries[i]);
        }
        this.names = names;
        this.size = size;
    }

    JCRPathExt(JCRPath.PathElement[] names) {
        this(names, names.length);
    }

    JCRPathExt(JCRPath.PathElement[] names, int size) {
        if (size < 0) {
            throw new AssertionError((Object)("Size value is negative: " + size));
        }
        if (size > names.length) {
            throw new AssertionError((Object)("Size value is too large: " + size + " instead of max: " + names.length));
        }
        this.names = names;
        this.size = size;
    }

    @Override
    public boolean isAbsolute() {
        JCRPath.PathElement first;
        return this.size > 0 && (first = this.names[0]).getName().equals("");
    }

    @Override
    JCRPath add(JCRPath path) {
        return new JCRPathExt(this, ((JCRPathExt)path).names, ((JCRPathExt)path).size);
    }

    @Override
    JCRPath addEntries(JCRPath.PathElement ... entries) {
        return new JCRPathExt(this, entries, entries.length);
    }

    @Override
    JCRPathExt addEntry(String namespace, String name, String prefix, int index) {
        return this.addEntry(JCRPathExt.element(namespace, name, prefix, index));
    }

    @Override
    public JCRPathExt makeAncestorPath(int relativeDegree) {
        return new JCRPathExt(this.names, this.size - relativeDegree);
    }

    @Override
    JCRPathExt addEntry(JCRPath.PathElement entry) {
        return new JCRPathExt(this, new JCRPath.PathElement[]{entry}, 1);
    }

    private static JCRPath.PathElement element(String namespace, String name, String prefix, int index) {
        if (name.equals(".")) {
            return THIS_ELEMENT;
        }
        if (name.equals("..")) {
            return MOVE_UP_ELEMENT;
        }
        return new JCRPath.PathElement(namespace, name, prefix, index);
    }

    private static int addEntry(JCRPath.PathElement[] entries, int size, JCRPath.PathElement entry) {
        if (entry == THIS_ELEMENT) {
            return size;
        }
        if (size > 0 && entry == MOVE_UP_ELEMENT && entries[size - 1] != MOVE_UP_ELEMENT) {
            if (size <= 0) {
                LOG.warn((Object)"Wrong relative path. Can't move up in path hierarhy.");
                return 0;
            }
            return size - 1;
        }
        entries[size] = entry;
        return size + 1;
    }

    @Override
    public JCRPathExt makeParentPath() {
        return this.makeAncestorPath(1);
    }

    @Override
    public int getLength() {
        return this.size;
    }

    @Override
    public JCRPath.PathElement getEntry(int index) {
        if (index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.names[index];
    }

    @Override
    public JCRPath.PathElement[] getRelPath(int relativeDegree) {
        JCRPath.PathElement[] relPath = new JCRPath.PathElement[relativeDegree];
        System.arraycopy(this.names, this.size - relativeDegree, relPath, 0, relativeDegree);
        return relPath;
    }

    @Override
    public QPath getInternalPath() {
        if (this.cachedInternalQPath == null) {
            QPathEntry[] entries = new QPathEntry[this.size];
            for (int i = 0; i < this.size; ++i) {
                entries[i] = new QPathEntry(this.names[i].getNamespace(), this.names[i].getName(), this.names[i].getIndex());
            }
            this.cachedInternalQPath = new QPath(entries);
        }
        return this.cachedInternalQPath;
    }

    @Override
    public String getAsString(boolean showIndex) {
        String path;
        if (showIndex) {
            if (this.cachedToStringShowIndex != null) {
                return this.cachedToStringShowIndex;
            }
        } else if (this.cachedToString != null) {
            return this.cachedToString;
        }
        if (this.isAbsolute()) {
            if (this.size == 1) {
                path = "/";
            } else {
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < this.size; ++i) {
                    builder.append("/").append(this.names[i].getAsString(showIndex));
                }
                path = builder.toString();
            }
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                if (i > 0) {
                    builder.append("/");
                }
                builder.append(this.names[i].getAsString(showIndex));
            }
            path = builder.toString();
        }
        if (showIndex) {
            this.cachedToStringShowIndex = path;
        } else {
            this.cachedToString = path;
        }
        return path;
    }

    @Override
    public int getDepth() {
        return this.size - 1;
    }

    @Override
    public boolean isDescendantOf(JCRPath ancestorLocation, boolean childOnly) {
        return this.isDescendantOf((JCRPathExt)ancestorLocation, childOnly);
    }

    public boolean isDescendantOf(JCRPathExt ancestorLocation, boolean childOnly) {
        int depthDiff = this.getDepth() - ancestorLocation.getDepth();
        if (depthDiff <= 0 || childOnly && depthDiff != 1) {
            return false;
        }
        JCRPath.PathElement[] anotherNames = ancestorLocation.names;
        for (int i = 0; i < ancestorLocation.size; ++i) {
            boolean result = anotherNames[i].equals(this.names[i]);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAncestorOf(JCRPath descendantLocation, boolean childOnly) {
        return descendantLocation.isDescendantOf(this, childOnly);
    }

    @Override
    public JCRPath.PathElement getName() {
        if (this.size > 0) {
            return this.names[this.size - 1];
        }
        return THIS_ELEMENT;
    }

    @Override
    public int getIndex() {
        return this.names[this.size - 1].getIndex();
    }

    @Override
    public boolean isIndexSetExplicitly() {
        return this.names[this.size - 1].isIndexSetExplicitly();
    }

    @Override
    public boolean isSameNameSibling(JCRPath anotherPath) {
        return this.isSameNameSibling((JCRPathExt)anotherPath);
    }

    public boolean isSameNameSibling(JCRPathExt anotherPath) {
        JCRPath.PathElement[] anotherNames = anotherPath.names;
        for (int i = 0; i < anotherPath.size - 1; ++i) {
            boolean result = ((JCRName)anotherNames[i]).equals(this.names[i]);
            if (result) continue;
            return false;
        }
        return this.getName().getName().equals(anotherPath.getName().getName()) && this.getName().getPrefix().equals(anotherPath.getName().getPrefix());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JCRPathExt) {
            JCRPathExt other = (JCRPathExt)obj;
            return this.getInternalPath().equals(other.getInternalPath());
        }
        return false;
    }

    @Override
    public JCRPath.PathElement[] getEntries() {
        return (JCRPath.PathElement[])this.names.clone();
    }
}

