/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileNameProducer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.FileNameProducer");
    private String backupSetName;
    private File backupSetDir;
    private boolean isFullBackup;
    private boolean isDirectoryForFullBackup;

    public FileNameProducer(String backupSetName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this.backupSetName = backupSetName;
        this.isFullBackup = isFullBackup;
        this.isDirectoryForFullBackup = isDirectory;
        this.backupSetDir = new File(backupDir);
        if (!PrivilegedFileHelper.exists((File)this.backupSetDir)) {
            PrivilegedFileHelper.mkdirs((File)this.backupSetDir);
        }
    }

    public static File generateBackupSetDir(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp) {
        FileNameProducer fileNameProducer = new FileNameProducer();
        String sTime = "-" + fileNameProducer.getStrDate(timeStamp) + "_" + fileNameProducer.getStrTime(timeStamp);
        File fBackupSetDir = new File(backupDir + File.separator + repositoryName + "_" + workspaceName + sTime);
        if (!PrivilegedFileHelper.exists((File)fBackupSetDir)) {
            PrivilegedFileHelper.mkdirs((File)fBackupSetDir);
        } else {
            int i = 2;
            while (PrivilegedFileHelper.exists((File)(fBackupSetDir = new File(backupDir + File.separator + repositoryName + "_" + workspaceName + sTime + "_" + i++)))) {
            }
        }
        return fBackupSetDir;
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup, boolean isDirectory) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, isDirectory);
    }

    public FileNameProducer(String repositoryName, String workspaceName, String backupDir, Calendar timeStamp, boolean isFullBackup) {
        this(repositoryName + "_" + workspaceName, backupDir, timeStamp, isFullBackup, false);
    }

    public FileNameProducer() {
    }

    public File getNextFile() {
        File nextFile = null;
        try {
            String sNextName = this.generateName();
            nextFile = new File(this.backupSetDir.getAbsoluteFile() + File.separator + sNextName);
            if (this.isFullBackup && this.isDirectoryForFullBackup) {
                if (!PrivilegedFileHelper.exists((File)nextFile)) {
                    PrivilegedFileHelper.mkdirs((File)nextFile);
                }
            } else {
                PrivilegedFileHelper.createNewFile((File)nextFile);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Can nit get next file : " + e.getLocalizedMessage()), (Throwable)e);
        }
        return nextFile;
    }

    private String generateName() {
        Calendar date = Calendar.getInstance();
        String sDate = this.getStrDate(date);
        String sTime = this.getStrTime(date);
        StringBuilder fileName = new StringBuilder(this.backupSetName).append("-").append(sDate).append("_").append(sTime).append(".");
        if (this.isFullBackup) {
            fileName.append("0");
        } else {
            fileName.append(this.getNextSufix());
        }
        return fileName.toString();
    }

    private String getNextSufix() {
        String[] fileList = PrivilegedFileHelper.list((File)this.backupSetDir, (FilenameFilter)new SkipBackupLogFilter());
        int sufix = 0;
        for (int i = 0; i < fileList.length; ++i) {
            String[] stringArray = fileList[i].split("[.]");
            int currentSufix = Integer.valueOf(stringArray[stringArray.length - 1]);
            if (currentSufix <= sufix) continue;
            sufix = currentSufix;
        }
        return String.valueOf(++sufix);
    }

    private String getStrDate(Calendar c) {
        int m = c.get(2) + 1;
        int d = c.get(5);
        return "" + c.get(1) + (Serializable)(m < 10 ? "0" + m : Integer.valueOf(m)) + (Serializable)(d < 10 ? "0" + d : Integer.valueOf(d));
    }

    private String getStrTime(Calendar c) {
        int h = c.get(10);
        int m = c.get(12);
        int s = c.get(13);
        return "" + (Serializable)(h < 10 ? "0" + h : Integer.valueOf(h)) + (Serializable)(m < 10 ? "0" + m : Integer.valueOf(m)) + (Serializable)(s < 10 ? "0" + s : Integer.valueOf(s));
    }

    public File getBackupSetDir() {
        return this.backupSetDir;
    }

    class SkipBackupLogFilter
    implements FilenameFilter {
        SkipBackupLogFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.endsWith(".xml");
        }
    }
}

