/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.representation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NtFileNodeRepresentation
implements NodeRepresentation {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.ext.resource.representation.NtFileNodeRepresentation");
    private Node node;
    private NodeRepresentation content;

    public NtFileNodeRepresentation(Node node, NodeRepresentation content) throws RepositoryException {
        this.node = node;
        this.content = content;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLenght() throws RepositoryException {
        return this.content.getContentLenght();
    }

    @Override
    public String getMediaType() throws RepositoryException {
        return this.content.getMediaType();
    }

    @Override
    public long getLastModified() throws RepositoryException {
        return this.content.getLastModified();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public HierarchicalProperty getProperty(String name) throws RepositoryException {
        if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name)) {
            return null;
        }
        if (this.content == null) {
            return null;
        }
        if (this.content.getProperty(name) != null) {
            return this.content.getProperty(name);
        }
        try {
            Property p = this.node.getProperty(name);
            String value = p.getDefinition().isMultiple() ? (p.getValues().length == 0 ? "" : p.getValues()[0].getString()) : p.getString();
            String ns = ((ExtendedSession)this.node.getSession()).getLocationFactory().parseJCRName(name).getNamespace();
            return new HierarchicalProperty(name, value, ns);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public Collection<HierarchicalProperty> getProperties(String name) throws RepositoryException {
        ArrayList<HierarchicalProperty> props;
        block7: {
            props = new ArrayList<HierarchicalProperty>();
            if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name)) {
                return null;
            }
            if (this.content != null && this.content.getProperty(name) != null) {
                props.addAll(this.content.getProperties(name));
            }
            try {
                String ns = ((ExtendedSession)this.node.getSession()).getLocationFactory().parseJCRName(name).getNamespace();
                Property p = this.node.getProperty(name);
                if (p.getDefinition().isMultiple()) {
                    Value[] v = p.getValues();
                    for (int i = 0; i < v.length; ++i) {
                        props.add(new HierarchicalProperty(name, v[i].getString(), ns));
                    }
                } else {
                    props.add(new HierarchicalProperty(name, p.getString(), ns));
                }
            }
            catch (PathNotFoundException e) {
                if (!LOG.isTraceEnabled()) break block7;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return props;
    }

    @Override
    public Collection<String> getPropertyNames() throws RepositoryException {
        PropertyIterator iter = this.node.getProperties();
        ArrayList<String> props = new ArrayList<String>();
        while (iter.hasNext()) {
            String name = iter.nextProperty().getName();
            if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name)) continue;
            props.add(name);
        }
        props.addAll(this.content.getPropertyNames());
        return props;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.content.getInputStream();
    }

    @Override
    public void addProperties(Collection<HierarchicalProperty> properties) throws UnsupportedRepositoryOperationException {
        this.content.addProperties(properties);
    }

    @Override
    public void addProperty(HierarchicalProperty property) throws UnsupportedRepositoryOperationException {
        this.content.addProperty(property);
    }

    @Override
    public void removeProperty(String name) throws UnsupportedRepositoryOperationException {
        this.content.removeProperty(name);
    }
}

