/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.ispn.IndexInfosKey;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.ActionNonTxAware;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;

@Listener
public class ISPNIndexInfos
extends IndexInfos
implements IndexerIoModeListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNIndexInfos");
    private static final String INDEX_NAMES = "$names".intern();
    private static final String SYSINDEX_NAMES = "$sysNames".intern();
    protected final Cache<Serializable, Object> cache;
    protected final IndexerIoModeHandler modeHandler;
    protected final IndexInfosKey namesKey;
    private final ActionNonTxAware<Void, Void, RuntimeException> write = new ActionNonTxAware<Void, Void, RuntimeException>(){

        protected TransactionManager getTransactionManager() {
            return ISPNIndexInfos.this.cache.getAdvancedCache().getTransactionManager();
        }

        protected Void execute(Void arg) {
            PrivilegedISPNCacheHelper.put(ISPNIndexInfos.this.cache, ISPNIndexInfos.this.namesKey, ISPNIndexInfos.this.getNames());
            return null;
        }
    };

    public ISPNIndexInfos(String wsId, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        this(wsId, "indexes", cache, system, modeHandler);
    }

    public ISPNIndexInfos(String wsId, String fileName, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        super(fileName);
        this.cache = cache;
        this.modeHandler = modeHandler;
        this.modeHandler.addIndexerIoModeListener(this);
        this.namesKey = new IndexInfosKey(wsId + (system ? SYSINDEX_NAMES : INDEX_NAMES));
        if (modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            cache.addListener((Object)this);
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        if (mode == IndexerIoMode.READ_WRITE) {
            this.cache.removeListener((Object)this);
            try {
                if (!this.multiIndex.isStopped()) {
                    super.read();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot read the list of index names", (Throwable)e);
            }
        } else {
            this.cache.addListener((Object)this);
        }
    }

    @Override
    public void write() throws IOException {
        if (this.isDirty() && this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            super.write();
            if (this.cache.getStatus() == ComponentStatus.RUNNING) {
                this.write.run();
            }
        }
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent<Serializable, Object> event) {
        Set set;
        if (!event.isPre() && ((Serializable)event.getKey()).equals(this.namesKey) && (set = (Set)event.getValue()) != null) {
            this.refreshIndexes(set);
        }
    }

    protected void refreshIndexes(Set<String> set) {
        if (set == null) {
            return;
        }
        this.setNames(set);
        try {
            MultiIndex multiIndex = this.getMultiIndex();
            if (multiIndex != null) {
                multiIndex.refreshIndexList();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to update indexes! " + e.getMessage()), (Throwable)e);
        }
    }
}

