/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;

final class ForeignSegmentDocId
extends DocId {
    static final ForeignSegmentDocId[] EMPTY_ARRAY = new ForeignSegmentDocId[0];
    private final int docNumber;
    private final long creationTick;

    ForeignSegmentDocId(int docNumber, long creationTick) {
        this.docNumber = docNumber;
        this.creationTick = creationTick;
    }

    int getDocNumber() {
        return this.docNumber;
    }

    long getCreationTick() {
        return this.creationTick;
    }

    @Override
    int[] getDocumentNumbers(MultiIndexReader reader, int[] docNumbers) throws IOException {
        int doc = reader.getDocumentNumber(this);
        if (doc == -1) {
            return EMPTY;
        }
        if (docNumbers.length == 1) {
            docNumbers[0] = doc;
            return docNumbers;
        }
        return new int[]{doc};
    }

    @Override
    DocId applyOffset(int offset) {
        return this;
    }

    @Override
    boolean isValid(BitSet deleted) {
        return true;
    }
}

