/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHitsAdapter;
import org.exoplatform.services.jcr.impl.core.query.lucene.SortedLuceneQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.constraint.EvaluationContext;

public class JcrIndexSearcher
extends IndexSearcher
implements EvaluationContext {
    private final SessionImpl session;
    private final IndexReader reader;
    private final ItemDataConsumer ism;

    public JcrIndexSearcher(SessionImpl s, IndexReader r, ItemDataConsumer ism) {
        super(r);
        this.session = s;
        this.reader = r;
        this.ism = ism;
    }

    public MultiColumnQueryHits execute(Query query, Sort sort, long resultFetchHint, InternalQName selectorName) throws IOException {
        return new QueryHitsAdapter(this.evaluate(query, sort, resultFetchHint), selectorName);
    }

    public QueryHits evaluate(final Query query, final Sort sort, final long resultFetchHint) throws IOException {
        return (QueryHits)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<QueryHits>(){

            @Override
            public QueryHits run() throws Exception {
                Query localQuery = query.rewrite(JcrIndexSearcher.this.reader);
                QueryHits hits = null;
                if (localQuery instanceof JcrQuery) {
                    hits = ((JcrQuery)localQuery).execute(JcrIndexSearcher.this, JcrIndexSearcher.this.session, sort);
                }
                if (hits == null) {
                    hits = sort == null || sort.getSort().length == 0 ? new LuceneQueryHits(JcrIndexSearcher.this.reader, JcrIndexSearcher.this, query) : new SortedLuceneQueryHits(JcrIndexSearcher.this.reader, JcrIndexSearcher.this, localQuery, sort, resultFetchHint);
                }
                return hits;
            }
        });
    }

    @Override
    public QueryHits evaluate(Query query) throws IOException {
        return this.evaluate(query, new Sort(), Integer.MAX_VALUE);
    }

    @Override
    public SessionImpl getSession() {
        return this.session;
    }

    @Override
    public ItemDataConsumer getItemStateManager() {
        return this.ism;
    }
}

