/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.text.NumberFormat;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemAutocreator;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.QueryImpl");
    public static final String JCR_SQL2 = "JCR-SQL2";
    public static final String JCR_JQOM = "JCR-JQOM";
    protected SessionImpl session;
    protected String statement;
    protected String language;
    protected ExecutableQuery query;
    protected Node node;
    protected QueryHandler handler;
    private boolean initialized = false;
    private long limit;
    private long offset;
    private boolean caseInsensitiveOrder;

    @Override
    public void init(SessionImpl session, SessionDataManager itemMgr, QueryHandler handler, String statement, String language) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.statement = statement;
        this.language = language;
        this.handler = handler;
        this.query = handler.createExecutableQuery(session, itemMgr, statement, language);
        this.setInitialized();
    }

    @Override
    public void init(SessionImpl session, SessionDataManager itemMgr, QueryHandler handler, Node node) throws InvalidQueryException, RepositoryException {
        this.checkNotInitialized();
        this.session = session;
        this.node = node;
        this.handler = handler;
        if (!((ExtendedNode)node).isNodeType(Constants.NT_QUERY)) {
            throw new InvalidQueryException("node is not of type nt:query");
        }
        this.statement = node.getProperty("jcr:statement").getString();
        this.language = node.getProperty("jcr:language").getString();
        this.query = handler.createExecutableQuery(session, itemMgr, this.statement, this.language);
        this.setInitialized();
    }

    public QueryResult execute() throws RepositoryException {
        this.checkInitialized();
        long time = 0L;
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis();
        }
        QueryResult result = this.query.execute(this.offset, this.limit, this.caseInsensitiveOrder);
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            String seconds = format.format((double)time / 1000.0);
            log.debug("executed in " + seconds + " s. (" + this.statement + ")");
        }
        return result;
    }

    public String getStatement() {
        this.checkInitialized();
        return this.statement;
    }

    public String getLanguage() {
        this.checkInitialized();
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        JCRPath path = this.session.getLocationFactory().parseAbsPath(absPath);
        QPath qpath = path.getInternalPath();
        NodeImpl parent = (NodeImpl)this.session.getTransientNodesManager().getItem(qpath.makeParentPath(), false);
        if (parent == null) {
            throw new PathNotFoundException("Parent not found for " + path.getAsString(false));
        }
        parent.validateChildNode(qpath.getName(), Constants.NT_QUERY);
        TransientNodeData queryData = TransientNodeData.createNodeData((NodeData)parent.getData(), qpath.getName(), Constants.NT_QUERY);
        NodeImpl queryNode = (NodeImpl)this.session.getTransientNodesManager().update(ItemState.createAddedState(queryData), false);
        NodeTypeDataManager ntmanager = this.session.getWorkspace().getNodeTypesHolder();
        ItemAutocreator itemAutocreator = new ItemAutocreator(ntmanager, this.session.getValueFactory(), this.session.getTransientNodesManager(), false);
        PlainChangesLog changes = itemAutocreator.makeAutoCreatedItems((NodeData)queryNode.getData(), Constants.NT_QUERY, this.session.getTransientNodesManager(), this.session.getUserID());
        for (ItemState autoCreatedState : changes.getAllStates()) {
            this.session.getTransientNodesManager().update(autoCreatedState, false);
        }
        TransientValueData value = new TransientValueData(this.language);
        TransientPropertyData jcrLanguage = TransientPropertyData.createPropertyData((NodeData)queryData, Constants.JCR_LANGUAGE, 1, false, value);
        this.session.getTransientNodesManager().update(ItemState.createAddedState(jcrLanguage), false);
        value = new TransientValueData(this.statement);
        TransientPropertyData jcrStatement = TransientPropertyData.createPropertyData((NodeData)queryData, Constants.JCR_STATEMENT, 1, false, value);
        this.session.getTransientNodesManager().update(ItemState.createAddedState(jcrStatement), false);
        this.node = queryNode;
        return this.node;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        this.checkInitialized();
        this.query.bindValue(this.session.getLocationFactory().parseJCRName(varName).getInternalName(), value);
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setCaseInsensitiveOrder(boolean caseInsensitiveOrder) {
        this.caseInsensitiveOrder = caseInsensitiveOrder;
    }

    protected void setInitialized() {
        this.initialized = true;
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

