/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionValue;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public final class PropertyDefinitionValue
extends ItemDefinitionValue
implements IUnmarshallable,
IMarshallable {
    private int requiredType;
    private List<String> valueConstraints;
    private List<String> defaultValueStrings;
    private boolean multiple;
    public static final String JiBX_bindingList = "|org.exoplatform.services.jcr.core.nodetype.JiBX_binding_nodetypevaluesFactory|";

    public PropertyDefinitionValue() {
    }

    public PropertyDefinitionValue(String name, boolean autoCreate, boolean mandatory, int onVersion, boolean readOnly, List<String> defaultValueStrings, boolean multiple, int requiredType, List<String> valueConstraints) {
        super(name, autoCreate, mandatory, onVersion, readOnly);
        this.defaultValueStrings = defaultValueStrings;
        this.multiple = multiple;
        this.requiredType = requiredType;
        this.valueConstraints = valueConstraints;
    }

    public PropertyDefinitionValue(PropertyDefinition propertyDefinition) throws RepositoryException {
        super((ItemDefinition)propertyDefinition);
        this.defaultValueStrings = this.convert(propertyDefinition.getDefaultValues());
        this.multiple = propertyDefinition.isMultiple();
        this.requiredType = propertyDefinition.getRequiredType();
        this.valueConstraints = propertyDefinition.getValueConstraints() != null ? Arrays.asList(propertyDefinition.getValueConstraints()) : new ArrayList();
    }

    public List<String> getDefaultValueStrings() {
        return this.defaultValueStrings;
    }

    public void setDefaultValueStrings(List<String> defaultValues) {
        this.defaultValueStrings = defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
    }

    public List<String> getValueConstraints() {
        return this.valueConstraints;
    }

    public void setValueConstraints(List<String> valueConstraints) {
        this.valueConstraints = valueConstraints;
    }

    private List<String> convert(Value[] values) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.add(values[i].getString());
        }
        return result;
    }

    public /* synthetic */ void JiBX_access_store_requiredType_2_0(int arg1) {
        this.requiredType = arg1;
    }

    public /* synthetic */ void JiBX_access_store_multiple_2_0(boolean arg1) {
        this.multiple = arg1;
    }

    public /* synthetic */ List JiBX_access_load_valueConstraints_2_0() {
        return this.valueConstraints;
    }

    public /* synthetic */ void JiBX_access_store_valueConstraints_2_0(List arg1) {
        this.valueConstraints = arg1;
    }

    public /* synthetic */ List JiBX_access_load_defaultValueStrings_2_0() {
        return this.defaultValueStrings;
    }

    public /* synthetic */ void JiBX_access_store_defaultValueStrings_2_0(List arg1) {
        this.defaultValueStrings = arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue";
    }

    public /* synthetic */ int JiBX_access_load_requiredType_2_0() {
        return this.requiredType;
    }

    public /* synthetic */ boolean JiBX_access_load_multiple_2_0() {
        return this.multiple;
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue").marshal((Object)this, arg1);
    }
}

