/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow.persistent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedItemData;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;

public class PersistedNodeData
extends PersistedItemData
implements NodeData,
Externalizable {
    private static final long serialVersionUID = 3033563403958948338L;
    private static final int ACL_IS_NULL = -1;
    private static final int ACL_IS_NOT_NULL = 1;
    protected int orderNumber;
    protected InternalQName primaryTypeName;
    protected InternalQName[] mixinTypeNames;
    protected AccessControlList acl;

    public PersistedNodeData() {
    }

    public PersistedNodeData(String id, QPath qpath, String parentId, int version, int orderNumber, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, AccessControlList acl) {
        super(id, qpath, parentId, version);
        this.primaryTypeName = primaryTypeName;
        this.mixinTypeNames = mixinTypeNames;
        this.orderNumber = orderNumber;
        this.acl = acl;
    }

    @Override
    public int getOrderNumber() {
        return this.orderNumber;
    }

    @Override
    public InternalQName getPrimaryTypeName() {
        return this.primaryTypeName;
    }

    @Override
    public InternalQName[] getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    @Override
    public AccessControlList getACL() {
        return this.acl;
    }

    @Override
    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        super.readExternal(in);
        this.orderNumber = in.readInt();
        try {
            buf = new byte[in.readInt()];
            in.readFully(buf);
            this.primaryTypeName = InternalQName.parse(new String(buf, "UTF-8"));
        }
        catch (IllegalNameException e) {
            throw new IOException(e.getMessage()){
                private static final long serialVersionUID = 3489809179234435267L;

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        int count = in.readInt();
        this.mixinTypeNames = new InternalQName[count];
        for (int i = 0; i < count; ++i) {
            try {
                buf = new byte[in.readInt()];
                in.readFully(buf);
                this.mixinTypeNames[i] = InternalQName.parse(new String(buf, "UTF-8"));
                continue;
            }
            catch (IllegalNameException e) {
                throw new IOException(e.getMessage()){
                    private static final long serialVersionUID = 3489809179234435268L;

                    @Override
                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        if (in.readInt() == 1) {
            this.acl = new AccessControlList();
            this.acl.readExternal(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.orderNumber);
        byte[] ptbuf = this.primaryTypeName.getAsString().getBytes("UTF-8");
        out.writeInt(ptbuf.length);
        out.write(ptbuf);
        out.writeInt(this.mixinTypeNames.length);
        for (int i = 0; i < this.mixinTypeNames.length; ++i) {
            byte[] buf = this.mixinTypeNames[i].getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        if (this.acl == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(1);
            this.acl.writeExternal(out);
        }
    }
}

