/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcludingRule;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ExcludingRuleImpl
implements ExcludingRule {
    private static final String NODE_TYPE = "nodeType";
    private static final String PATH = "path";
    private final QPath excludePath;
    private final InternalQName excludeNodeType;
    private final NodeTypeDataManager ntReg;

    ExcludingRuleImpl(Node configNode, NodeTypeDataManager ntReg, LocationFactory resolver) throws IllegalNameException, RepositoryException {
        NamedNodeMap attributes = configNode.getAttributes();
        Node path = attributes.getNamedItem(PATH);
        this.excludePath = path == null ? null : new QPath(resolver.parseAbsPath(path.getNodeValue()).getInternalPath().getEntries());
        Node nodeType = attributes.getNamedItem(NODE_TYPE);
        this.excludeNodeType = nodeType == null ? null : resolver.parseJCRName(nodeType.getNodeValue()).getInternalName();
        this.ntReg = ntReg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludeNodeType == null ? 0 : this.excludeNodeType.hashCode());
        result = 31 * result + (this.excludePath == null ? 0 : this.excludePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludingRuleImpl other = (ExcludingRuleImpl)obj;
        if (this.excludeNodeType == null && other.excludeNodeType != null) {
            return false;
        }
        if (this.excludeNodeType != null && !this.excludeNodeType.equals((Object)other.excludeNodeType)) {
            return false;
        }
        if (this.excludePath == null && other.excludePath != null) {
            return false;
        }
        return this.excludePath == null || this.excludePath.equals(other.excludePath);
    }

    @Override
    public boolean suiteFor(NodeData state) {
        boolean suiteForPath = this.excludePath == null ? true : this.validateByPath(state);
        boolean suiteForNodeType = this.excludeNodeType == null ? true : this.validateByNodeType(state);
        return suiteForPath && suiteForNodeType;
    }

    private boolean validateByPath(NodeData state) {
        return state.getQPath().isDescendantOf(this.excludePath) || state.getQPath().equals(this.excludePath);
    }

    private boolean validateByNodeType(NodeData state) {
        return this.ntReg.isNodeType(this.excludeNodeType, state.getPrimaryTypeName(), state.getMixinTypeNames());
    }
}

