/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.query.lucene.ComparableBoolean;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReleaseableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.TextFieldExtractor;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class Util {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.Util");

    public static void disposeDocument(Document old) {
        for (Fieldable f : old.getFields()) {
            try {
                if (f.readerValue() != null) {
                    f.readerValue().close();
                    continue;
                }
                if (!(f instanceof TextFieldExtractor)) continue;
                TextFieldExtractor field = (TextFieldExtractor)f;
                field.dispose();
            }
            catch (IOException ex) {
                log.warn((Object)("Exception while disposing index document: " + ex));
            }
        }
    }

    public static Query createMatchAllQuery(String name, IndexFormatVersion version) {
        if (version.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new JcrTermQuery(new Term(FieldNames.PROPERTIES_SET, name));
        }
        return new MatchAllQuery(name);
    }

    public static IOException createIOException(Throwable t) {
        IOException ex = new IOException(t.getMessage());
        ex.initCause(t);
        return ex;
    }

    public static void closeOrRelease(IndexReader reader) throws IOException {
        if (reader instanceof ReleaseableIndexReader) {
            ((ReleaseableIndexReader)reader).release();
        } else {
            reader.close();
        }
    }

    public static Comparable<?> getComparable(ValueData value, int type) throws UnsupportedEncodingException, IllegalStateException, IOException, IllegalNameException, RepositoryException {
        switch (type) {
            case 2: {
                return null;
            }
            case 6: {
                return ComparableBoolean.valueOf(ValueDataUtil.getBoolean(value));
            }
            case 5: {
                return new Long(ValueDataUtil.getDate(value).getTimeInMillis());
            }
            case 4: {
                return new Double(ValueDataUtil.getDouble(value));
            }
            case 3: {
                return new Long(ValueDataUtil.getLong(value));
            }
            case 7: {
                return new QPathEntry(ValueDataUtil.getName(value), 1);
            }
            case 8: {
                return ValueDataUtil.getPath(value);
            }
            case 9: {
                return ValueDataUtil.getReference(value);
            }
            case 1: {
                return ValueDataUtil.getString(value);
            }
        }
        return null;
    }

    public static <A, B> int compare(Comparable<A> c1, Comparable<B> c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        if (c1.getClass() == c2.getClass()) {
            return c1.compareTo(c2);
        }
        String name1 = c1.getClass().getName();
        String name2 = c2.getClass().getName();
        return name1.compareTo(name2);
    }

    public static Pattern createRegexp(String likePattern) {
        StringBuilder regexp = new StringBuilder();
        boolean escaped = false;
        block4: for (int i = 0; i < likePattern.length(); ++i) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                if (escaped) {
                    regexp.append("\\\\").append(likePattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(likePattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(likePattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (likePattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(likePattern.charAt(i));
                }
            }
        }
        return Pattern.compile(regexp.toString(), 32);
    }

    public static long getLength(ValueData value, int propType) {
        if (propType == 2) {
            return value.getLength();
        }
        if (propType == 7 || propType == 8) {
            return -1L;
        }
        return value.toString().length();
    }
}

