/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.StreamExporter;

public class SystemViewStreamExporter
extends StreamExporter {
    private static final int BUFFER_SIZE = 9216;
    private static final List<String> exportedVersionHistories = new ArrayList<String>();

    public SystemViewStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        this(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse, false);
    }

    public SystemViewStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse, boolean exportChildVersionHistory) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse, exportChildVersionHistory);
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            this.writer.writeStartElement("sv", "node", this.getSvNamespaceUri());
            if (level == 0) {
                this.startPrefixMapping();
            }
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", this.getExportName(node, false));
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        try {
            this.writer.writeStartElement("sv", "property", this.getSvNamespaceUri());
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", this.getExportName(property, false));
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "type", ExtendedPropertyType.nameFromValue(property.getType()));
            List<ValueData> values = property.getValues();
            for (ValueData valueData : values) {
                this.writer.writeStartElement("sv", "value", this.getSvNamespaceUri());
                this.writeValueData(valueData, property.getType());
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            if (this.exportChildVersionHistory && node.getPrimaryTypeName().equals((Object)Constants.NT_VERSIONEDCHILD)) {
                try {
                    PropertyData childVersionHistory = (PropertyData)this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_CHILDVERSIONHISTORY, 1), ItemType.PROPERTY);
                    String childVersionHistoryId = this.getValueAsStringForExport(childVersionHistory.getValues().get(0), childVersionHistory.getType());
                    if (!exportedVersionHistories.contains(childVersionHistoryId)) {
                        this.writer.writeStartElement("sv", "versionhistory", this.getSvNamespaceUri());
                        this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", childVersionHistoryId);
                        NodeData versionStorage = (NodeData)this.dataManager.getItemData("00exo0jcr0version0storage0uuid00");
                        NodeData childVersionNodeData = (NodeData)this.dataManager.getItemData(versionStorage, new QPathEntry("", childVersionHistoryId, 1), ItemType.NODE);
                        childVersionNodeData.accept(this);
                        this.writer.writeEndElement();
                        exportedVersionHistories.add(childVersionHistoryId);
                    }
                }
                catch (IOException e) {
                    throw new RepositoryException("Can't export versioned child version history: " + e.getMessage(), (Throwable)e);
                }
            }
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeValueData(ValueData data, int type) throws RepositoryException, IllegalStateException, XMLStreamException, IOException {
        if (2 == type) {
            if (!this.isSkipBinary()) {
                try (InputStream is = data.getAsStream();){
                    int len;
                    byte[] buffer = new byte[9216];
                    while ((len = is.read(buffer)) > 0) {
                        char[] charbuf1 = Base64.encode((byte[])buffer, (int)0, (int)len, (int)0, (String)"").toCharArray();
                        this.writer.writeCharacters(charbuf1, 0, charbuf1.length);
                    }
                }
            }
        } else {
            String charValue = this.getValueAsStringForExport(data, type);
            if (SystemViewStreamExporter.hasValidCharsOnly(charValue)) {
                this.writer.writeCharacters(charValue.toCharArray(), 0, charValue.length());
            } else {
                byte[] content = charValue.getBytes("UTF-8");
                char[] charbuf = Base64.encode((byte[])content, (int)0, (int)content.length, (int)0, (String)"").toCharArray();
                this.writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:base64Binary");
                this.writer.writeCharacters(charbuf, 0, charbuf.length);
            }
        }
    }
}

