/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class ResampledGridCoverage
extends GridCoverage {
    private static final int BIDIMENSIONAL = 2;
    final GridCoverage source;
    private final MathTransform toSourceCorner;
    private final MathTransform toSourceCenter;
    private final long[] toSourceDimensions;
    private final ImageProcessor imageProcessor;
    private final int supportSizeX;
    private final int supportSizeY;

    private ResampledGridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry, MathTransform mathTransform, MathTransform mathTransform2, CoordinateOperationFinder coordinateOperationFinder, ImageProcessor imageProcessor) {
        super(gridCoverage, gridGeometry);
        this.source = gridCoverage;
        this.toSourceCorner = mathTransform;
        this.toSourceCenter = mathTransform2;
        this.toSourceDimensions = ResampledGridCoverage.findDependentDimensions(mathTransform2, gridGeometry);
        imageProcessor = imageProcessor.clone();
        imageProcessor.setFillValues(SampleDimensions.backgrounds(this.getSampleDimensions()));
        coordinateOperationFinder.setAccuracyOf(imageProcessor);
        this.imageProcessor = GridCoverageProcessor.unique(imageProcessor);
        Dimension dimension = this.imageProcessor.getInterpolation().getSupportSize();
        this.supportSizeX = dimension.width;
        this.supportSizeY = dimension.height;
    }

    private static long[] findDependentDimensions(MathTransform mathTransform, GridGeometry gridGeometry) {
        int n = mathTransform.getSourceDimensions();
        if (n <= 2) {
            return null;
        }
        Matrix matrix = MathTransforms.getMatrix((MathTransform)mathTransform);
        if (matrix == null) {
            try {
                matrix = mathTransform.derivative((DirectPosition)new DirectPositionView.Double(gridGeometry.getExtent().getPointOfInterest()));
            }
            catch (TransformException transformException) {
                GridCoverageProcessor.recoverableException("resample", (Exception)((Object)transformException));
                return null;
            }
        }
        int n2 = mathTransform.getTargetDimensions();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (matrix.getElement(j, i) == 0.0) continue;
                if (j >= 64) {
                    throw GridGeometry.excessiveDimension(mathTransform);
                }
                int n3 = i;
                lArray[n3] = lArray[n3] | 1L << j;
            }
        }
        return lArray;
    }

    private GridCoverage specialize(boolean bl) throws TransformException {
        MathTransform mathTransform;
        GridExtent gridExtent = this.gridGeometry.getExtent();
        if (gridExtent.getDimension() < 2 || gridExtent.getSubDimension() > 2) {
            return this;
        }
        if (!bl && this.toSourceCorner instanceof LinearTransform && (mathTransform = this.gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER)) instanceof LinearTransform) {
            GridGeometry gridGeometry;
            GridGeometry gridGeometry2 = this.source.getGridGeometry();
            if (gridGeometry2.equals(gridGeometry = new GridGeometry(gridExtent = gridGeometry2.getExtent(), PixelInCell.CELL_CORNER, mathTransform = MathTransforms.concatenate((MathTransform)this.toSourceCorner.inverse(), (MathTransform)mathTransform), this.getCoordinateReferenceSystem()), ComparisonMode.APPROXIMATE)) {
                return this.source;
            }
            return new GridCoverage2D(this.source, gridGeometry, gridExtent, this.source.render(null));
        }
        return new GridCoverage2D(this.source, this.gridGeometry, gridExtent, this.render(null));
    }

    static boolean equivalent(GridGeometry gridGeometry, GridGeometry gridGeometry2) {
        return !(ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 4) && !Utilities.equalsIgnoreMetadata((Object)gridGeometry.getExtent(), (Object)gridGeometry2.getExtent()) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 1) && !Utilities.equalsIgnoreMetadata((Object)gridGeometry.getCoordinateReferenceSystem(), (Object)gridGeometry2.getCoordinateReferenceSystem()) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 8) && !Utilities.equalsIgnoreMetadata((Object)gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER), (Object)gridGeometry2.getGridToCRS(PixelInCell.CELL_CORNER)) && !Utilities.equalsIgnoreMetadata((Object)gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER), (Object)gridGeometry2.getGridToCRS(PixelInCell.CELL_CENTER)) || ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 2) && !ResampledGridCoverage.isDefined(gridGeometry, gridGeometry2, 12) && !gridGeometry.equalsApproximately(gridGeometry2.envelope));
    }

    private static boolean isDefined(GridGeometry gridGeometry, GridGeometry gridGeometry2, int n) {
        return gridGeometry2.isDefined(n) && gridGeometry.isDefined(n);
    }

    static GridCoverage create(GridCoverage gridCoverage, GridGeometry gridGeometry, ImageProcessor imageProcessor) throws FactoryException, TransformException {
        Object object;
        MatrixSIS matrixSIS;
        Object object2;
        Object object3;
        Serializable serializable;
        MathTransform mathTransform;
        GridExtent gridExtent;
        GridGeometry gridGeometry2 = gridCoverage.getGridGeometry();
        CoordinateOperationFinder coordinateOperationFinder = new CoordinateOperationFinder(gridGeometry2, gridGeometry);
        coordinateOperationFinder.verifyPresenceOfCRS(true);
        MathTransform mathTransform2 = coordinateOperationFinder.gridToCRS();
        MathTransform mathTransform3 = coordinateOperationFinder.inverse();
        coordinateOperationFinder.setAnchor(PixelInCell.CELL_CENTER);
        MathTransform mathTransform4 = coordinateOperationFinder.gridToCRS();
        MathTransform mathTransform5 = coordinateOperationFinder.inverse();
        boolean bl = gridGeometry.isDefined(4);
        GridExtent gridExtent2 = gridExtent = bl ? gridGeometry.getExtent() : null;
        if (gridGeometry.isDefined(8)) {
            bl = true;
            mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
            if (gridExtent == null) {
                gridExtent = ResampledGridCoverage.targetExtent(gridGeometry2.getExtent(), mathTransform2, gridGeometry.getGridToCRS(PixelInCell.CELL_CORNER).inverse(), false);
            }
        } else {
            Object object4;
            int n;
            int n2;
            serializable = gridGeometry2.getExtent();
            object3 = ((GridExtent)serializable).getPointOfInterest();
            object2 = new double[mathTransform4.getTargetDimensions()];
            matrixSIS = MatrixSIS.castOrCopy((Matrix)MathTransforms.derivativeAndTransform((MathTransform)mathTransform4, (double[])object3, (int)0, (double[])object2, (int)0));
            object = matrixSIS.multiply(object3);
            MatrixSIS matrixSIS2 = matrixSIS.normalizeColumns();
            int n3 = matrixSIS.getNumRow();
            int n4 = gridGeometry.getDimension();
            int n5 = Math.min(matrixSIS2.getNumCol(), Math.min(n3, n4));
            MatrixSIS matrixSIS3 = Matrices.create((int)(n4 + 1), (int)(n3 + 1), (Number[])ExtendedPrecisionMatrix.ZERO);
            int[] nArray = n4 > n3 && gridExtent != null ? gridExtent.getSubspaceDimensions(n3) : null;
            while (true) {
                double d = -1.0;
                n2 = -1;
                int n6 = -1;
                for (n = 0; n < n5; ++n) {
                    int n7 = nArray != null ? nArray[n] : n;
                    for (int i = 0; i < n3; ++i) {
                        double d2 = Math.abs(matrixSIS.getElement(i, n7));
                        if (!(d2 > d)) continue;
                        d = d2;
                        n6 = i;
                        n2 = n7;
                    }
                }
                if (n2 < 0) break;
                for (n = 0; n < n3; ++n) {
                    matrixSIS.setElement(n, n2, Double.NaN);
                }
                for (n = 0; n < n4; ++n) {
                    matrixSIS.setElement(n6, n, Double.NaN);
                }
                DoubleDouble doubleDouble = DoubleDouble.castOrCopy((Number)matrixSIS2.getNumber(0, n2));
                doubleDouble.inverseDivide(1.0);
                matrixSIS3.setNumber(n2, n6, (Number)doubleDouble);
                doubleDouble.multiply(object[n6] - object2[n6]);
                matrixSIS3.setNumber(n2, n3, (Number)doubleDouble);
            }
            matrixSIS3.setElement(n4, n3, 1.0);
            GridExtent gridExtent3 = ResampledGridCoverage.targetExtent((GridExtent)serializable, mathTransform2, (MathTransform)MathTransforms.linear((Matrix)matrixSIS3), true);
            if (gridExtent == null) {
                if (gridExtent3.startsAtZero()) {
                    gridExtent = gridExtent3;
                } else {
                    object4 = new long[n4 * 2];
                    for (n2 = 0; n2 < n4; ++n2) {
                        object4[n2 + n4] = (DoubleDouble)(gridExtent3.getSize(n2) - 1L);
                    }
                    gridExtent = new GridExtent(gridExtent3, (long[])object4);
                }
            }
            object4 = new DoubleDouble();
            DoubleDouble doubleDouble = new DoubleDouble();
            DoubleDouble doubleDouble2 = new DoubleDouble();
            for (n = 0; n < n4; ++n) {
                doubleDouble2.set(gridExtent.getSize(n));
                object4.set(gridExtent3.getSize(n));
                object4.inverseDivide(doubleDouble2);
                doubleDouble2.set(gridExtent.getLow(n));
                doubleDouble.set(-gridExtent3.getLow(n));
                doubleDouble.multiply(object4);
                doubleDouble.add(doubleDouble2);
                matrixSIS3.convertAfter(n, (Number)object4, (Number)doubleDouble);
            }
            mathTransform = MathTransforms.linear((Matrix)matrixSIS3.inverse());
        }
        serializable = gridGeometry;
        object3 = ComparisonMode.IGNORE_METADATA;
        if (!gridGeometry.isDefined(13)) {
            object2 = coordinateOperationFinder.getTargetCRS();
            serializable = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, mathTransform, (CoordinateReferenceSystem)object2);
            object3 = ComparisonMode.APPROXIMATE;
            if (gridGeometry.isDefined(2)) {
                matrixSIS = ((GridGeometry)serializable).getGridToCRS(PixelInCell.CELL_CORNER);
                object = new GeneralEnvelope(((GridGeometry)serializable).getEnvelope());
                object.intersect(gridGeometry.getEnvelope());
                object = Envelopes.transform((MathTransform)matrixSIS.inverse(), (Envelope)object);
                gridExtent = new GridExtent((AbstractEnvelope)object, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, gridExtent, null);
                serializable = new GridGeometry(gridExtent, PixelInCell.CELL_CENTER, mathTransform, (CoordinateReferenceSystem)object2);
                bl = true;
            }
        }
        if (gridGeometry2.equals(serializable, (ComparisonMode)object3)) {
            return gridCoverage;
        }
        object2 = ((GridGeometry)serializable).getGridToCRS(PixelInCell.CELL_CORNER);
        return new ResampledGridCoverage(gridCoverage, (GridGeometry)serializable, MathTransforms.concatenate((MathTransform)object2, (MathTransform)mathTransform3), MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)mathTransform5), coordinateOperationFinder, imageProcessor).specialize(bl);
    }

    private static GridExtent targetExtent(GridExtent gridExtent, MathTransform mathTransform, MathTransform mathTransform2, boolean bl) throws TransformException {
        MathTransform mathTransform3 = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)mathTransform2);
        GeneralEnvelope generalEnvelope = gridExtent.toCRS(mathTransform3, mathTransform3, null);
        if (bl) {
            double[] dArray = new double[generalEnvelope.getDimension()];
            Arrays.fill(dArray, 0.5);
            generalEnvelope.translate(dArray);
        }
        return new GridExtent((AbstractEnvelope)generalEnvelope, GridRoundingMode.NEAREST, GridClippingMode.STRICT, null, null, null, null);
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        MathTransform mathTransform;
        GridExtent gridExtent2;
        int n;
        int n2;
        Object object;
        if (gridExtent == null) {
            gridExtent = this.gridGeometry.getExtent();
        }
        try {
            int n3;
            object = gridExtent.getSubspaceDimensions(2);
            n2 = Math.toIntExact(gridExtent.getSize(object[0]));
            n = Math.toIntExact(gridExtent.getSize(object[1]));
            GeneralEnvelope generalEnvelope = gridExtent.toCRS(this.toSourceCorner, this.toSourceCenter, null);
            int n4 = generalEnvelope.getDimension();
            if (generalEnvelope.isEmpty()) {
                GridExtent gridExtent3 = this.source.gridGeometry.getExtent();
                for (n3 = 0; n3 < n4; ++n3) {
                    double d = generalEnvelope.getMinimum(n3);
                    double d2 = generalEnvelope.getMaximum(n3);
                    if (Double.isNaN(d)) {
                        d = gridExtent3.getLow(n3);
                    }
                    if (Double.isNaN(d2)) {
                        d2 = gridExtent3.getHigh(n3);
                    }
                    generalEnvelope.setRange(n3, d, d2);
                }
            }
            int n5 = 0;
            n3 = 1;
            if (this.toSourceDimensions != null) {
                int n6;
                long l = 0L;
                for (int n7 : object) {
                    l |= this.toSourceDimensions[n7];
                }
                n5 = Long.numberOfTrailingZeros(l);
                n3 = Long.numberOfTrailingZeros(l & (1L << n5 ^ 0xFFFFFFFFFFFFFFFFL));
                if (n3 >= n4) {
                    if (n5 >= n4) {
                        n5 = 0;
                    }
                    n3 = n5 != 0 ? 0 : 1;
                    l = 1L << n5 | 1L << n3;
                }
                l ^= 0xFFFFFFFFFFFFFFFFL;
                while ((n6 = Long.numberOfTrailingZeros(l)) < n4) {
                    double d = generalEnvelope.getMedian(n6);
                    if (Double.isFinite(d)) {
                        generalEnvelope.setRange(n6, d, d);
                    }
                    l &= 1L << n6 ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
            int[] nArray = new int[n4];
            nArray[n5] = this.supportSizeX;
            nArray[n3] = this.supportSizeY;
            gridExtent2 = new GridExtent((AbstractEnvelope)generalEnvelope, GridRoundingMode.ENCLOSING, null, nArray, null, null, null);
            TransformSeparator transformSeparator = new TransformSeparator(this.toSourceCenter);
            transformSeparator.addSourceDimensions(object);
            transformSeparator.addTargetDimensions(new int[]{n5, n3});
            transformSeparator.setSourceExpandable(true);
            MathTransform mathTransform2 = transformSeparator.separate();
            int[] nArray2 = transformSeparator.getSourceDimensions();
            if (nArray2.length > 2) {
                MatrixSIS matrixSIS = Matrices.createZero((int)(nArray2.length + 1), (int)3);
                matrixSIS.setElement(nArray2.length, 2, 1.0);
                for (int n7 = 0; n7 < nArray2.length; ++n7) {
                    int n8 = nArray2[n7];
                    int n9 = Arrays.binarySearch(object, n8);
                    if (n9 >= 0) {
                        matrixSIS.setElement(n7, n9, 1.0);
                        continue;
                    }
                    long l = gridExtent.getLow(n8);
                    if (l == gridExtent.getHigh(n8)) {
                        matrixSIS.setElement(n7, 2, (double)l);
                        continue;
                    }
                    throw new CannotEvaluateException(Resources.format((short)63, gridExtent.getAxisIdentification(n8, n8)));
                }
                mathTransform2 = MathTransforms.concatenate((MathTransform)MathTransforms.linear((Matrix)matrixSIS), (MathTransform)mathTransform2);
            }
            LinearTransform linearTransform = MathTransforms.translation((double[])new double[]{gridExtent.getLow(object[0]), gridExtent.getLow(object[1])});
            LinearTransform linearTransform2 = MathTransforms.translation((double[])new double[]{Math.negateExact(gridExtent2.getLow(n5)), Math.negateExact(gridExtent2.getLow(n3))});
            mathTransform = MathTransforms.concatenate((MathTransform)linearTransform, (MathTransform)mathTransform2, (MathTransform)linearTransform2);
        }
        catch (ArithmeticException | TransformException | FactoryException throwable) {
            throw new CannotEvaluateException(throwable.getLocalizedMessage(), throwable);
        }
        object = this.source.render(gridExtent2);
        return this.imageProcessor.resample((RenderedImage)object, new Rectangle(n2, n), mathTransform);
    }

    @Override
    final DataType getBandType() {
        return this.source.getBandType();
    }

    @Override
    public GridEvaluator evaluator() {
        return this.source.evaluator();
    }
}

